;****************************************************************************
;PLAY: 
;WILL PASS AUDIO FROM LEFT CHANNEL STRAIGHT THROUGH TO 
;BOTH LEFT AND RIGHT CHANNELS
;***************************************************************************

        include 'sincos.asm'
        include 'fftr2a.asm'

START   EQU     $40
coef    EQU     $1000
data    EQU     $2000
points  EQU     $400
saram   EQU     $A000           ;A000

        sincos  points,coef

        org     p:$0
        jmp     START

        org     p:$000c
        jsr     ssi_rx_isr      ;SSI receive data
        jsr     ssi_rx_isr      ;SSI receive data with exception
        jsr     ssi_tx_isr      ;SSI transmit data
        jsr     ssi_tx_isr      ;SSI transmit with exception

        org     p:START

        movep   #$040006,x:PLL  ;these labels are defined in the 
        movep   #0000,x:BCR     ;ada_init.asm program
        ori     #3,mr           ;mask interrupts
        movec   #0,sp           ;clear hardware stack pointer
        move    #0,omr          ;operating mode 0
        move    #$40,r6         ;initialise stack pointer
        move    #-1,m6          ;linear addressing

        movep   #$0000,y:$fff8	;SARAM start address buffer1
        movep   #$07ff,y:$fff9	;SARAM end address buffer1
        movep   #$0800,y:$fffa	;SARAM start address buffer2
        movep   #$0fff,y:$fffb	;SARAM end address buffer1
        movep   #$0000,y:$fffc
        movep   #$0000,y:$fffd
	
		include 'ada_init.asm'

TONE_OUTPUT     EQU     HEADPHONE_EN+LINEOUT_EN+(0*LEFT_ATTN)+(0*RIGHT_ATTN)
TONE_INPUT      EQU     MIC_IN_SELECT

		move    #TONE_OUTPUT,y0         ;set up control words
		move    y0,x:TX_BUFF_BASE+2
		move    #TONE_INPUT,y0
		move    y0,x:TX_BUFF_BASE+3
	
        move    #data,r1
        move    #points-1,m1
        move    #$ffff,n1
        move    #saram,r2
        move    #points-1,m2
        move    #$ffff,n2

_loop1
		jclr	#0,x:$ffe9,_no_word_from_hp
		move	#CTRL_WD_12,a1
		movep	x:$ffeb,x0
		or		x0,a
		move	a1,x:TX_BUFF_BASE
		move	a1,x:$ffeb

		jmp		codec_init

_no_word_from_hp

		jset    #2,x:SSISR,*    	;wait for frame sync to pass
		jclr    #2,x:SSISR,*    	;wait for frame sync

		move    x:RX_BUFF_BASE,a        ;receive left
		move    x:RX_BUFF_BASE+1,b      ;receive right
       
		move    a,x:TX_BUFF_BASE        ;transmit left
		move    b,x:TX_BUFF_BASE+1      ;transmit right
	
		rep     #8
		asr     a

		move    #0,b

		move    a,x:(r1)
	        move    b,y:(r1)+

		and		#$FB,CCR
	        move    #data,a
		move	r1,x0
		cmp		x0,a
		jne		_buf1

		fftr2a  points,data,coef

       move    #data,r1
       move    #points-1,m1
       move    #$ffff,n1
       move    #saram,r2
       move    #0,m2
       move    #points/2,n2
	
       do		#points,_reorder
       move    x:(r1),x0
       move    y:(r1)+,y0
       mpy     x0,x0,a
       nop
       mac     y0,y0,a
		rep		#8
		asr		a
        nop
       move    a,p:(r2)+n2
_reorder

        move    #data,r1
        move    #points-1,m1
        move    #$ffff,n1
        move    #saram,r2
        move    #points-1,m2
        move    #$ffff,n2


		do		#points,_copybuf
		move		y:(r1)+,a
;		rep		#8
;		asr		a
		move		a,p:(r2)+
_copybuf
		movep	#$0001,y:$fff1

_buf1		
		jclr	#0,y:$fffd,_buf2
		bclr	#0,y:$fffd
_buf2
		jclr	#1,y:$fffd,_loop1
		bclr	#1,y:$fffd

		
        jmp     _loop1                  ;go back to the beginning

        include 'txrx_isr.asm'

        end
