#ifndef KANALYZERWIDGET_H 
#define KANALYZERWIDGET_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qtoolbutton.h>
#include <qbuttongroup.h>

#include <kapp.h>
#include <kdisplay.h>
#include <ktoolbox.h>
#include <ktoolbar.h>
#include <kpanel.h>
#include <kdevice.h>

class KAnalyzerWidget : public QWidget
{
	Q_OBJECT
public:
	KAnalyzerWidget(QWidget *parent = 0, const char *name = 0);
	virtual ~KAnalyzerWidget();
	
	KToolBar   *deviceBar;
	KToolBar   *displayBar;

	QButtonGroup* devicegroup;
	QToolButton* stopbtn;
	QToolButton* sinebtn;
	QToolButton* waveinbtn;
	QToolButton* dsp56btn;

	QButtonGroup* domaingroup;
	QToolButton* timebtn;
	QToolButton* frequencybtn;

	QButtonGroup* markergroup;
	QToolButton* maxmarkerbtn;
	QToolButton* marker1btn;
	QToolButton* marker2btn;
	QToolButton* exmarkerbtn;
	QToolButton* killmarkerbtn;

	KToolbox* ptoolbox;
	KPanel* panel;
	
	KDisplay* pdisplay;
	KSine* psinedevice;
	KWaveIn* pwavein;
	KDSP56* pdsp56;

public:

public slots:
	void device(int);
	void domain(int);
	void marker(int);
};

#endif // KANALYZERWIDGET_H 
