#include <ktoolbox.h>
#include <ktoolbox.moc>

#include <qpixmap.h>
#include <qpainter.h>
#include <qpoint.h>
#include <qtoolbutton.h>
#include <qbuttongroup.h>

#include <kdevice.h>
#include <kdisplay.h>

#include <xpm/toolbox.xpm>
#include <xpm/sine.xpm>
#include <xpm/wavein.xpm>
#include <xpm/goldammer.xpm>
#include <xpm/time.xpm>
#include <xpm/frequency.xpm>
#include <xpm/stop.xpm>
#include <xpm/redmarker.xpm>
#include <xpm/exchangemarker.xpm>
#include <xpm/yellowmarker.xpm>
#include <xpm/maxmarker.xpm>
#include <xpm/killmarker.xpm>

/* constants */
const char* chToolBox = "Setup";
const QPoint ptToolBox(30,20);
const QPoint ptToolBoxPixmap(0,0);

const char* chSamplefrequency = "Sample Rate";
const QPoint ptSamplefrequency(5,85);

const char* chFrq = "kHz";
const QRect rFrq(60,90, 35, 25);

const QRect rsamplefrequencyctrl(5,90, 55, 25); 
const char* chsamplefrequencyctrl = "32000";

const char* chTrigger = "Trigger";
const QRect rTrigger(5,120, 80, 25);

const char* chFFTDevice = "FFT in\nDevice";
const QRect rFFTDevice(5,150, 80, 40);

KToolbox::KToolbox(QWidget *parent, const char *name)
	: QFrame(parent, name)
{
	f = QFont("Times", 14, QFont::Bold);
	setFont(f);

	samplefrequencyctrl = new QLineEdit(this);
	samplefrequencyctrl->setGeometry(rsamplefrequencyctrl);

	samplefrequencyctrl->setFont(f);
	samplefrequencyctrl->setText(chsamplefrequencyctrl);
	
	triggerctrl = new QCheckBox(chTrigger, this);
	triggerctrl->setGeometry(rTrigger);
	triggerctrl->setFont(f);
	
	devicefftctrl = new QCheckBox(chFFTDevice, this);
	devicefftctrl->setGeometry(rFFTDevice);
	devicefftctrl->setFont(f);

}

KToolbox::~KToolbox()
{
}

void KToolbox::paintEvent(QPaintEvent* ev)
{
	QFrame::paintEvent(ev);
	
	QPainter paint(this);
	paint.drawPixmap(ptToolBoxPixmap,QPixmap((const char **)toolbox_xpm));
	paint.drawText(ptToolBox,chToolBox);
	paint.drawText(ptSamplefrequency,chSamplefrequency);
	paint.drawText(rFrq,AlignCenter, chFrq);
}
