/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */
#include <a_cad.hxx>

void Arista_CAD::write(ostream& os)
{
  os <<"  Edge:"<<this<<"; ref:"<<refa
     <<"; Kind of edge:" << front<<";  with vertices:"<<endl
     <<c[0]<<", ref:"<<refv[0]<<endl
     <<c[1]<<"; ref:"<<refv[1]<<endl
     <<"Tangentes."<<endl
     <<tg.tang[0]<<endl<<tg.tang[1]<<flush;
}

ostream& operator<<(ostream& os, Arista_CAD& ss) {ss.write(os); return os;}

int Arista_CAD::vertice(R2 c0) {
  int pos=-1;
  if (c0==c[0]) pos=0;
  if (c0==c[1]) pos=1;
  return pos;
}
Scalar angle(Arista_CAD* a1, Arista_CAD* a2) {
  Scalar a0;
  R2 v1,v2;
  int pos,sig[2];
  sig[0]=1;sig[1]=0; 
  if ((*a1)<(*a2)) {
    v1=a1->c[1]-a1->c[0];
    v2=a2->c[1]-a2->c[0];
  }
  else {
    pos=a2->vertice(a1->c[0]);
    if (pos>=0) {
      v1=a1->c[0]-a1->c[1];
      v2=a2->c[sig[pos]]-a2->c[pos];
    }
    else {
      pos=a2->vertice(a1->c[1]);
      if (pos>=0) {
        v1=a1->c[1]-a1->c[0];
        v2=a2->c[sig[pos]]-a2->c[pos];
      }
      else {
        cerr<<"Error. Edges with no common vertex."<<endl;
        cerr<<"Error in angle (Arista_CAD.C)."<<endl;
        exit(1);
      }
    }
  }   
  a0=angle(v1,v2);
  return a0;
}  


/*         DISTANCIA DE UN PUNTO A UNA ARISTA        
                                                
   Proposito: Calcular la distancia de un punto a una arista.
   --------- 

   Entrada:   
   -------    pt= punto;
   
   Salida:    dist = distancia del punto a la arista.
   ------     pr_pt= Coordenadas del punto proyectado.
              temp = valor comprendido entre 0 y 1;
-----------------------------------------------------------------
*/ 

Scalar Arista_CAD::distancia(const R2& pt, R2& pr_pt,Scalar& temp) {
  Scalar dist;
  dist=proyec(c[0],c[1],pt,pr_pt,temp);
  return dist;
}

R2 Arista_CAD::eval(Scalar t0) {
  R2 pt(0,0);
  pt=(cf[0]*t0*t0*t0+cf[1]*t0*t0+cf[2]*t0+cf[3])*.5;
  return pt;
}
