/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#ifndef _AristaT0_c
#define _AristaT0_c

#include <a_t0.hxx>

void Arista_T0::write(ostream& os)
{os <<"  Arista:"<<this<<"; De nodos:"<< s[0]<<", "<<s[1]<<"; ref:"
    <<ref<<"; Frontera:" << front<<flush;}

ostream& operator<<(ostream& os, Arista_T0& ss) {ss.write(os); return os;}

int Arista_T0::vertice(Vertice_T0* s0) {
   int pos=-1;
   if (s0==s[0]) pos=0;
   if (s0==s[1]) pos=1;
   return pos;
}
Scalar angle(Arista_T0* a1, Arista_T0* a2) {
      Scalar a0;
      R2 v1,v2;
      int pos,sig[2];
      sig[0]=1;sig[1]=0; 
      if ((*a1)<(*a2)) {
         v1=(a1->s[1])->c-(a1->s[0])->c;
         v2=(a2->s[1])->c-(a2->s[0])->c;
      }
      else {
         pos=a2->vertice(a1->s[0]);
         if (pos>=0) {
            v1=(a1->s[0])->c-(a1->s[1])->c;
            v2=(a2->s[sig[pos]])->c-(a2->s[pos])->c;
         }
         else {
            pos=a2->vertice(a1->s[1]);
            if (pos>=0) {
               v1=(a1->s[1])->c-(a1->s[0])->c;
               v2=(a2->s[sig[pos]])->c-(a2->s[pos])->c;
            }
            else {
                cerr<<"Las aristan no tienen un vertice comun. (angle)"<<endl;
                exit(1);
            }
         }
      }   
      a0=angle(v1,v2);
      return a0;
 }  


void Arista_T0::m_ref() {
      ref=0;
      if (this->frontera()) {
          if (s[0]->ref>0)
               ref=s[0]->ref;
          else
               ref=-s[0]->ref;
      }
 }

/*         DISTANCIA DE UN PUNTO A UNA ARISTA        
                                                
   Proposito: Calcular la distancia de un punto a una arista.
   --------- 

   Entrada:   aa= arista;
   -------    pt= punto;
   
   Salida:    dist = distancia del punto a la arista.
   ------     pr_pt= Coordenadas del punto proyectado.
-----------------------------------------------------------------
*/ 

Scalar d_arete (const Arista_T0& aa, const R2& pt, R2& pr_pt) {

   Scalar dist,temp;

   dist=proyec(aa.s[0]->c,aa.s[1]->c,pt,pr_pt,temp);
   return dist;
 }
 
    
#endif
