/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr)
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */



#ifndef _CAD_h
#define _CAD_h


#include <a_cad_dl.hxx>
#include <m_t0.hxx>

struct FraristaCAD_link {

  Arista_CAD_dlist* Aretelist;
  FraristaCAD_link* suc;
  FraristaCAD_link* prev;
  
  FraristaCAD_link() {Aretelist=NIL; suc=NIL; prev=NIL;}
  FraristaCAD_link(Arista_CAD_dlist* Al, FraristaCAD_link* ss,\
                   FraristaCAD_link* pp)
  {Aretelist=Al; suc=ss; prev=pp;}
  FraristaCAD_link(Arista_CAD_dlist& Al, FraristaCAD_link* ss,\
                  FraristaCAD_link* pp)
  {Aretelist=&Al; suc=ss; prev=pp;}
  
  void set(Arista_CAD_dlist* Al, FraristaCAD_link* ss,\
           FraristaCAD_link* pp)
  {Aretelist=Al; suc=ss; prev=pp;}
  void set(Arista_CAD_dlist& Al, FraristaCAD_link* ss,\
           FraristaCAD_link* pp)
  {Aretelist=&Al; suc=ss; prev=pp;}
  FraristaCAD_link* sig() {return suc;}
  FraristaCAD_link* ant() {return prev;}
  void operator delete (void* p) 
  {
    if (p) {
      Arista_CAD_dlist* aux=((FraristaCAD_link*)p)->Aretelist;
      if (aux) {delete aux; aux=NIL;}
      delete p;
      p=NIL;
    }
  }   
  int operator<(const FraristaCAD_link& a)
  {return ((*Aretelist)<(*(a.Aretelist)));}
  
};

class CAD {
  
  FraristaCAD_link* last;
  FraristaCAD_link* begin;
  int angulo;
  
  friend ostream& operator<<(ostream&,CAD&);
  
public:
//    ***** Constructores ******
  
  CAD () {last=NIL; begin=NIL; angulo=45;}
  CAD (FraristaCAD_link* f) {last=begin=f;angulo=45;}
  void set_angulo(int ann) {angulo=ann;}
  
//   ******     Creacion de la lista *****
  
  void insert (FraristaCAD_link* f) { //add at head of list
    if (begin) {
      begin->prev=f;
      f->suc=begin;
      begin=f;
    }
    else  {
      last=f;
      begin=f;
    }
  }
  void append (FraristaCAD_link* f) {  //add at end of list
    if (last)  {
      last->suc=f;
      f->prev=last;
      last=f;
    }
    else {
      last=f;
      begin=f;
    }
  }
  void enlaza(FraristaCAD_link* f1, FraristaCAD_link* f2,int od)
  {
    /* une f1->Aretelist+f2->Aretelist si od=1.
       Si od=-1 enlaza f2->Aretelist+f1->Aretelist.
       despues debes destruir f2.
       */
    // ***** En laza las dos listas  *****
    Arista_CAD_dlist* aux;
    if (od==1) 
      (f1->Aretelist)->enlaza(f2->Aretelist);
    else { 
      aux=f1->Aretelist;
      (f2->Aretelist)->enlaza(f1->Aretelist);
      f1->Aretelist=f2->Aretelist;
      f2->Aretelist=aux;
    }
    if (f2==begin) {
      begin=f2->suc;
      begin->prev=NIL;
    }
    else {
      if (f2==last) {
        last=f2->prev;
        last->suc=NIL;
      }
      else {
        (f2->prev)->suc=f2->suc;
        (f2->suc)->prev=f2->prev;
      }
    }
  }
  
  
  Boolean testeo(); 
  friend CAD* crea_frontera(Mallado_T0*,int);
  friend CAD* build(Triangulation*,int,Scalar);
  void Tangentes(int);
  void P_control();
  void Pinta(int);
  int angul() { return angulo;}
//  ***** Dan los parametros de la lista  ****
  
  FraristaCAD_link* principio() {return begin;}
  FraristaCAD_link* fin () {return last;}
  int num_elem() {
    int num=0;
    FraristaCAD_link* aux=begin;
    while (aux) {
      num++;
      aux=aux->suc;
    }
    return num;
  }
  
//  Scalar d_frontera(R2,R2&,Arista_T0&,Triangulo_T0&,\
//                    const Scalar&);
  
// ******    Destructores    ******
  
  void clear () {
    FraristaCAD_link* aux;
    while(begin) {
      aux=begin->suc;
      delete begin;
      begin=aux;
    }
    last=begin=NIL;
  }
  
  void operator delete (void* p)
  {  
    if (p) {
      ((CAD*)p)->clear();
      delete p;p=NIL;
    }
  }  
  void write(ostream&);
};


#endif
