/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#include <header.hxx>
#include <metric.hxx>

int lecmtr(Metrica* mtr, char* name, Scalar scale,int nbs) {
  Scalar coef1,coef2,coef3;
  int i;
#ifdef DEBUG
  cout<<"========================================================"<<endl;
  cout<<"              READING METRIC FROM A FILE."<<endl;
  cout<<"========================================================"<<endl;
#endif /* DEBUG */
  OPENI(lectura, name);
  for (i=0; i<nbs; i++){
    lectura>>coef1>>coef2>>coef3;
    mtr[i].set(coef1,coef2,coef3);
    mtr[i]=mtr[i]/(scale*scale);
  }
  lectura.close();
  return 0;
}
