/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#ifndef _regeneramalla_h
#define _regeneramalla_h

#include <header.hxx>
#include <m_t1.hxx>
#include <v_t1_l.hxx>
#include <front_t1.hxx>
#include <cad.hxx>

typedef Arista_T1_dlink* p_lkArista;

extern void verifica(Triangulo_T1_dlist*,Arista_T1_dlist*,Vertice_T1_dlist*);
extern void busca_inters(Vertice_T1_dlist*);
extern Boolean busca_criterio(Triangulo_T1_dlist*);
extern void t_vecinos(Vertice_T1*,Triangulo_T1_dlist&);
extern void t_local(Vertice_T1*,Triangulo_T1_dlist&);
extern int mshopt(Triangulo_T1*,const int&);
int mshap(Triangulo_T1_dlist*, Arista_T1_dlist*, Vertice_T1_dlist*,
          Triangulo_T1* ,Arista_T1*,Mallado_T0*,CAD*,int);
int mshsar(Triangulo_T1_dlist*, Vertice_T1_dlist*, p_lkArista*,
           Triangulo_T1_dlist*,Vertice_T1*,Vertice_T1*, Arista_T1*, 
           int, Mallado_T0*,CAD*,int);
void filtrado (Triangulo_T1_dlist*,Arista_T1_dlist*,Vertice_T1_dlist*,
               Mallado_T0*,int,int,Boolean,Scalar,int,Boolean,CAD*,int);

extern void escmesh2D(char*,Triangulo_T1_dlist*,Vertice_T1_dlist*,
                      int,int,Scalar);
extern void escsol(int,int,char*,Scalar*);
extern Scalar* interpolacion(Vertice_T1_dlist*,Mallado_T0*,int,Scalar*,Triangulo_T1_dlist*,int);
extern void cal_long(Arista_T1_dlist*, Mallado_T0*,int,int);
extern void the_clock(double *);
extern Arista_CAD_dlink*  proyeccion_cao (CAD*,R2,R2&,Arista_CAD_dlink*,int,int);
#endif
