/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#ifndef _metrica_h
#define _metrica_h

#include <header.hxx>
#include <r2.hxx> 


 class Metrica {
  friend ostream& operator<<(ostream&, Metrica&);
public:  
  Scalar coef[3];
  Scalar factor;
  Metrica (); 
  Metrica (Scalar,Scalar,Scalar);
  Metrica (Scalar,Scalar,Scalar,Scalar);
  Metrica (Scalar*); 
  
  void set (Scalar,Scalar,Scalar);
  void set (Scalar,Scalar,Scalar,Scalar);
  void set (Scalar*);
  void set (const Metrica&);
  Metrica&  operator=(const Metrica&);
  Metrica   operator+(Metrica);
  Metrica   operator*(Scalar);
  R2        operator*(R2);
  Metrica   operator*(Metrica);
  Metrica   inv(int&);
  Metrica   operator/(Scalar);
  Scalar determinante();
  void write (ostream&);
};






#endif


    
