/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#ifndef _verticeT1dlist_h
#define _verticeT1dlist_h

#include <v_t1.hxx>

   struct Vertice_T1_dlink {
       Vertice_T1* s;
       int pos;
       Vertice_T1_dlink* suc;
       Vertice_T1_dlink* prev;

       Vertice_T1_dlink () {s=NIL; suc=NIL; prev=NIL;pos=0;}
       Vertice_T1_dlink (Vertice_T1& so, Vertice_T1_dlink* ss,\
                         Vertice_T1_dlink* pp)
            {s=&so;suc=ss;prev=pp;pos=0;}
       Vertice_T1_dlink (Vertice_T1* so, Vertice_T1_dlink* ss,\
                         Vertice_T1_dlink* pp) {
             s=so; suc=ss; prev=pp;pos=0;} 

       void set (Vertice_T1& so, Vertice_T1_dlink* ss,\
                 Vertice_T1_dlink* pp)
            {s=&so; suc=ss;prev=pp;pos=0;}
       void set (Vertice_T1* so, Vertice_T1_dlink* ss,\
                 Vertice_T1_dlink* pp) {
              s=so; suc=ss; prev=pp;pos=0;} 

       Vertice_T1_dlink* sig() {return suc;}
       Vertice_T1_dlink* ant() {return prev;}
       void operator delete (void* p) {
        if (p) {
          Vertice_T1* aux;
          aux=((Vertice_T1_dlink*)p)->s;
          if (aux) {delete aux; aux=NIL;}
          delete p; p=NIL;
        }
       }

    };

    class Vertice_T1_dlist {

       Vertice_T1_dlink* last;
       Vertice_T1_dlink* begin;

       friend ostream& operator<<(ostream&, Vertice_T1_dlist&);

   public:
       Vertice_T1_dlist () {last=NIL; begin=NIL;}
       Vertice_T1_dlist (Vertice_T1_dlink* r) {last=begin=r;}
       void insert (Vertice_T1_dlink* r) {//pega al principio de dlist
           if (begin) {
               r->suc=begin;
               begin->prev=r;
               begin=r;

           }
           else {
               last=r;
               begin=r;
           }
       }
       void append(Vertice_T1_dlink* r) {//pega al final de dlist
           if (last) {
              last->suc=r;
              r->prev=last;
              last=r;
           }
           else {
              last=r;
              begin=r;
           }
       }
       void  enlaza (Vertice_T1_dlist* rll) {  //une this+rll
        if (begin) {
           if (rll->begin) {
              last->suc=rll->begin;
              (rll->begin)->prev=last;
              last=rll->last;
              rll->begin=NIL;
              rll->last=NIL;
           }
        }
        else {
           begin=rll->begin;
           last=rll->last;
           rll->begin=NIL;
           rll->last=NIL;
       }
   }
       void  enlaza (Vertice_T1_dlist& rll) {  //une this+rll
        if (begin) {
           if (rll.begin) {
              last->suc=rll.begin;
              (rll.begin)->prev=last;
              last=rll.last;
              rll.begin=NIL;
              rll.last=NIL;
           }
        }
        else {
           begin=rll.begin;
           last=rll.last;
           rll.begin=NIL;
           rll.last=NIL;
       }

    }
       void kill (Vertice_T1_dlink* r) { //elimina un elmento de la dlista
         if (r) {
           if (r==begin) {
              begin=r->suc;
              if (begin) begin->prev=NIL;
           }
           else {
             if (r==last) {
                last=r->prev;
                last->suc=NIL;
             }
             else {
               (r->prev)->suc=r->suc;
               (r->suc)->prev=r->prev;
             }
           }
           delete r; r=NIL;
         }
       }

       Vertice_T1_dlink* principio () {return begin;}
       Vertice_T1_dlink* fin () {return last;}
       int num_elem () {
           int num=0;
           Vertice_T1_dlink* aux=begin;
           while (aux) {
            num++;
            aux=aux->suc;
           }
           return num;
       } 
       void clear () {
           Vertice_T1_dlink* aux;
           while (begin) {
              aux=begin->suc;
              delete begin;
              begin=aux;
           }
           last=begin=NIL;
       }                             
       void operator delete (void* p){
         if (p) {
           ((Vertice_T1_dlist*)p)->clear();
           delete p; p=NIL;
         }
       }
       void write (ostream&);
       void numera() {
          Vertice_T1_dlink* aux;
          int cont=0;
          aux=begin;
          while(aux) { 
              cont++;
              aux->pos=cont;
              aux=aux->sig();
          }
       }

                   
    };
#endif       
