// Emacs will be in -*- Mode: c++ -*-
//
// ********** DO NOT REMOVE THIS BANNER **********
//
// SUMMARY: Language for a Finite Element Method
// RELEASE: 2.0     
// USAGE  : You may copy freely these files and use it for    
//          teaching or research. These or part of these may   
//          not be sold or used for a commercial purpose with- 
//          out our consent : fax (33)1 44 27 44 11        
//
// AUTHORS:  D. Bernardi, Y. Darmaillac F. Hecht,    
//           P. Parole O. Pironneau C. Prud'homme
// ORG    :          
// E-MAIL :   pironneau@ann.jussieu.fr     
//
// ORIG-DATE:     June-94
// LAST-MOD:      3-Jan-96 at 13:40:55 by Prud'homme Christophe
//
// DESCRIPTION:  
// DESCRIP-END.
//

#ifndef __LEXICAL_H
#define __LEXICAL_H

#define MAXIDENTS 200


typedef enum
{
  lpar, rpar,   lbrace, rbrace, cste,   newvar, oldvar, plus,   minus,  star,
  slash, modulo, lt,  le,   gt,   ge,   eq,   neq,  comma,  semicolon, colon,sine, 
  cosine,logarithm, exponential, root, absolute, expo, acose, asine, tane, et,
  coshe, sinhe, tanhe, ou, mini, maxi, partial_x, partial_y, si, alors, 
  autrement, loop, error, _end, becomes, fdecl, symb_bdy, symb_build, atane, fctdef,
  symb_solv, symb_dch, symb_frr, symb_id, symb_lapl, symb_div, trace,
  changewait,trace3d, chaine,  
  sauve, charge, sauvmsh, chargmsh, arret, fctfile, div_x, div_y, symb_convect,evalfct,
  symb_exec, sauvetout, symb_user, partreal, partimag, symb_system, symb_pde,
  id_bdy, dnu_bdy,  
  d_xx, d_xy, d_yy, d_yx, symb_complex, symb_precise, prodscal, one, wait_state,
  nowait, nographics, rhsconvect,adaptmesh,polygon,gint,bint,bracketr,bracketl,varsolve,penall
} Symbol;

typedef struct
{
 char *name;
 Symbol symb;
 creal value;
 creal *table;
} ident;

typedef struct
{
 int bdy, build, onbdy, solv, fct, si, eq, param,t,fem, syst, complexe, precise, graphics;
} drapeaux;

typedef struct programme
{
 char *thestring, *curchar;
 Symbol sym;
 int numligne;
 struct programme *pere;
} programme;

extern int numligne;
extern char *thestring, *curchar;
extern drapeaux flag;
extern Symbol cursym;
extern float curcst;
extern ident *curident;
extern char curchaine[100];
extern int numidents;
extern ident idents[MAXIDENTS];
extern programme *curprog;

long wherearewe();
void initlex(char *);
void nextsym(void);
void closelex();

#endif /* __LEXICAL_H */
