/*

    $Id: about.cpp,v 1.1 1997/08/04 23:21:12 wuebben Exp $
       
    Copyright (C) 1997 Bernd Johannes Wuebben   
                       wuebben@math.cornell.edu

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "about.h"
#include "version.h"
#include <qpushbt.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <kapp.h>

extern KApplication *mykapp;

About::About(QWidget *parent) : QDialog(parent, "About KFem", TRUE) {
  resize(450, 360);
  setFixedSize(size());
  setCaption("About KFem");

  QString pixdir = mykapp->kdedir() + QString("/share/kfem/");  
  QPixmap pm((pixdir + "kfemlogo.xpm").data());
  QLabel *logo = new QLabel(this);
  logo->setPixmap(pm);
  logo->setGeometry(20, (height()-pm.height())/2 - 20, pm.width(), pm.height());

  QLabel *l;
  l = new QLabel("KFem", this);
  l->setFont(QFont("Utopia", 26, QFont::Normal));
  l->setGeometry((width() - l->sizeHint().width())/2, 20,
		 l->sizeHint().width(), 
		 l->sizeHint().height());

  QString s;
  s = "Version " KFEMVERSION \
  "\n(c) 1997 Christophe Prud'homme\n\nASCI Laboratory France\nhttp://www.asci.fr\n\nchristophe.prudhomme@asci.fr\n\n" \
  "This program is free software; you can redistribute it and/or modify "\
  "it under the terms of the GNU General Public License. See the help documentation for "\
  "details.";


  l = new QLabel(s.data(), this);
  l->setGeometry(170, 70, 240, 220);
  l->setAlignment(AlignLeft|WordBreak|ExpandTabs);

  QPushButton *b_ok = new QPushButton("Ok", this);
  b_ok->setGeometry(width()/2-40, height() - 48, 80, 32);
  b_ok->setDefault(TRUE);
  b_ok->setAutoDefault(TRUE);
  connect(b_ok, SIGNAL(released()),
	  this, SLOT(accept()));
  b_ok->setFocus();
}

#include "about.moc"
