#include <math.h>
#include <stdio.h>
#include <iostream.h>

#include <qstring.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qprinter.h>

#include "debug.h"
#include "page.h"

#include "plot.h"
#include "plot.moc"

#include <kapp.h>
#include <kconfig.h>


Plot* activePlot = 0;

PlotList& Plots ()
{
  static PlotList plotPrototypeList;
  return plotPrototypeList;
}


Plot* Plot::defaultPlot ()
{
  QString DefaultPlot;
  KConfig* conf;
  Plot* iter;

  conf = KApplication::getKApplication()->getConfig();
  conf->setGroup("Plot");
  if (strcmp(conf->group(),"Plot") == 0)
	{
	  DefaultPlot = conf->readEntry("default_plot");
	  if (DefaultPlot.isEmpty())
		{
		  IFDEBUG("korigin.plot",1)
			cout << "Default plot not set, using first plot in list as"
				 << " default." << endl;
		  ENDDEBUG;
		  return Plots().at(0);
		} 
	  else 
		{
		  for (iter=Plots().first(); iter!=0; iter=Plots().next())
			if (strcmp(iter->name(),DefaultPlot) == 0) {
			  IFDEBUG("korigin.plot",2)
				cout << "Default plot type is: " << DefaultPlot << endl;
			  ENDDEBUG;
			  return iter;
			}
		  IFDEBUG("korigin.plot",1)
			cout << DefaultPlot << " not found, using first plot in list as"
				 << " default." << endl;
		  ENDDEBUG;
		  return Plots().at(0);
		}
	}
  IFDEBUG("korigin.plot",1)
	cout << "Configuration has no [Plot] group, using first plot in list as"
		 << " default." << endl;
  ENDDEBUG;
  return Plots().at(0);
}


Plot::Plot () : PageObject()
{
  IFDEBUG("korigin.plot",4)
	cout << "Plot::Plot() starts." << endl;
  ENDDEBUG;

  the_widget = 0;
  the_menu = 0;
  active_icon = inactive_icon = 0;

  IFDEBUG("korigin.plot",4)
	cout << "Plot::Plot() ends." << endl;
  ENDDEBUG;
}


void Plot::instantiate (Page* p, QWidget* parent, const char* name, WFlags f)
{
  IFDEBUG("korigin.plot",4)
	cout << "Plot::instantiate() starts." << endl;
  ENDDEBUG;

  setPage(p);

  IFDEBUG("korigin.plot",3)
	cout << "Plot::instantiate() page set." << endl;
  ENDDEBUG;

  delete the_widget;
  the_widget = new QWidget(parent,name,f);
  delete the_menu;
  the_menu = new QPopupMenu();
  the_menu->insertItem("Plot columns!",this,SLOT(plotSelectedColumns()));

  IFDEBUG("korigin.plot",3)
	cout << "Plot::instantiate() menu & widget built.." << endl;
  ENDDEBUG;

  treeitem()->setPixmap(active_icon);
  treeitem()->setText(description());

  IFDEBUG("korigin.plot",4)
	cout << "Plot::instantiate() ends." << endl;
  ENDDEBUG;
}


Plot::~Plot ()
{
  IFDEBUG("korigin.plot",4)
	cout << "Plot::~Plot() starts." << endl;
  ENDDEBUG;

  delete the_menu;
  the_menu = 0;
  delete the_widget;
  the_widget = 0;
  delete active_icon;
  active_icon = 0;
  delete inactive_icon;
  inactive_icon = 0;

  if (activePlot == this) activePlot = 0;

  IFDEBUG("korigin.plot",4)
	cout << "Plot::~Plot() emits signal." << endl;
  ENDDEBUG;

  emit changedTreeItem ();

  IFDEBUG("korigin.plot",4)
	cout << "Plot::~Plot() ends." << endl;
  ENDDEBUG;
}


void Plot::activate ()
{
  treeitem()->setPixmap(active_icon);
}


void Plot::deactivate ()
{
  treeitem()->setPixmap(inactive_icon);
}


void Plot::paintEvent (QPaintEvent*)
{
  IFDEBUG("korigin.plot",4)
	cout << "Plot::paintEvent() starts." << endl;
  ENDDEBUG;

  QPainter p;
  p.begin(the_widget);
  paint(&p);
  p.end();

  IFDEBUG("korigin.plot",4)
	cout << "Plot::paintEvent() ends." << endl;
  ENDDEBUG;
}


