#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include <qmsgbox.h>

#include "debug.h"
#include "formula.h"
#include "table.h"


//
// class Table
//

const char* Table::TableUnnamedStr = "Unbenannt";


static Column current_table [1024];

static double TableLookup (const char* column_name, int index)
{
  int i;
  for (i=0; i<1024; i++) {
	if (current_table[i].type() == Column::columnEmpty)
	  return NAN;
	if (current_table[i].type() == Column::columnDouble)
	  if (strcmp(current_table[i].title(),column_name) == 0)
		return current_table[i][index-1];
  }
  return NAN;
}

static void FormulaErrorHandler (const char* message, const char* context)
{
  static char buffer [2048];
  sprintf(buffer,"The formula interpreter reports the following"\
		  " error:\n%s\n%s",message,context);
  QMessageBox::warning(0,"Error in Formula",buffer);
}

class TableInitClass
{
public:
  TableInitClass () {
	Formula::setLookupFunction(TableLookup);
	Formula::setErrorFunction(FormulaErrorHandler);
  }
};


Table::Table ()
{
  static TableInitClass tableInitializer;
  the_dim = 0;
  the_name = newStr(TableUnnamedStr);
}


Table::~Table ()
{
  delete [] the_name;
}


void Table::dump ()
{
  int i, j;
  cout << "Table::dump() of table " << the_name << endl;
  for (i=0; i<width(); i++)
	cout << title(i) << "\t";
  cout << endl;
  for (j=0; j<height(); j++)
	{
	  for (i=0; i<width(); i++)
		cout << cell(i,j) << "\t";
	  cout << endl;
	}
}


Table* Table::clone ()
{
  int i;
  Table* T2 = new Table;

  T2->the_dim = the_dim;
  T2->the_name = newStr(the_name);
  for (i=0; i<the_dim; i++)
    T2->the_column[i] = the_column[i];

  IFDEBUG("korigin.table",3)
	cout << "Table::clone(): done." << endl;
  ENDDEBUG;

  return T2;
}


Column Table::column (int col)
{
  if (col<0 || col>=the_dim) return Column(Column::columnEmpty);
  return the_column[col];
}


int Table::width ()
{
  return the_dim;
}


int Table::height ()
{
  int i, tmp, max = 0;
  for (max=0, i=0; i<the_dim; i++)
	{
	  tmp = height(i);
	  IFDEBUG("korigin.table",3)
		cout << "col. " << i << " height " << tmp << endl;
	  ENDDEBUG;
	  if (tmp > max)
		max = tmp;
	}
  return max+1;
}


int Table::height (int col)
{
  if (col<0 || col>=the_dim) return 0;
  return the_column[col].dim();
}


const char* Table::cell (int col, int row)
{
  markActive();
  if (col<0 || col>=the_dim) return 0;
  return the_column[col].value(row);
}


void Table::getCell (int col, int row, char* str)
{
  markActive();
  if (col<0 || col>=the_dim) {
	str[0]=0;
	return;
  }
  strcmp(str,the_column[col].value(row));
}


void Table::setCell (int col, int row, const char* str)
{
  if (col<0 || col>=the_dim) return;
  the_column[col].setValue(row,str);
}


int Table::findColumn (const char* a_title)
{
  int i;
  for (i=0; i<the_dim; i++)
	{
	  if (the_column[i].type() == Column::columnEmpty) continue;
	  if (strcmp(the_column[i].title(),a_title) == 0)
		return i;
	}
  return -1;
}


void Table::markActive ()
{
  int i;
  for (i=0; i<the_dim; i++)
	current_table[i] = the_column[i];
  current_table[i] = Column(Column::columnEmpty);
}


void Table::insertColumn (int at, Column new_column)
{
  IFDEBUG("korigin.table",3)
	cout << "Table::insertColumn("<<at<<","<<new_column.type()<<")" << endl;
  ENDDEBUG;

  int i;
  if (at<0 || at>the_dim) return;
  if (the_dim + 1 >= MaxSize) return;
  for (i=the_dim; i>at; i--)
	the_column[i] = the_column[i-1];
  the_column[at] = new_column;
  the_dim++;

  IFDEBUG("korigin.table",3)
	cout << "Table::insertColumn() succeeded." << endl;
  ENDDEBUG;
}

void Table::insertRow (int at)
{
  int i, j, len;
  len = height();
  for (j=0; j<the_dim; j++)
	{
	  for (i=len-1; i>=at; i--)
		the_column[j].setValue(i+1,the_column[j].value(i));
	  the_column[j].setValue(at,"");
	}
}

void Table::deleteColumn (int at)
{
  int i;
  if (at >= the_dim || the_dim == 0) return;
  for (i=at; i<the_dim-1; i++)
	the_column[i] = the_column[i+1];
  the_column[the_dim] = Column(Column::columnEmpty);
  the_dim--;
}

void Table::deleteRow (int at)
{
  int i, j, len;
  len = height();
  if (len < 1) return;
  for (j=0; j<the_dim; j++)
	{
	  for (i=at; i<len-1; i++)
		the_column[j].setValue(i,the_column[j].value(i+1));
	  the_column[j].setValue(len-1,0);
	}
}

Column::ColumnType Table::type (int col)
{
  if (col<0 || col>=the_dim) return Column::columnEmpty;
  return the_column[col].type();
}

const char* Table::name ()
{
  return the_name;
}

void Table::setName (const char* new_name)
{
  delete [] the_name;
  the_name = newStr(new_name);
}

const char* Table::title (int col)
{
  if (col<0 || col>=the_dim) return 0;
  return the_column[col].title();
}

const char* Table::format (int col)
{
  if (col<0 || col>=the_dim) return 0;
  return the_column[col].format();
}

void Table::setTitle  (int col, const char* new_title)
{
  if (col<0 || col>=the_dim) return;
  the_column[col].setTitle(new_title);
}

void Table::setFormat (int col, const char* new_format)
{
  if (col<0 || col>=the_dim) return;
  the_column[col].setFormat(new_format);
}

