#ifndef __WS_HIGHLIGHTING_H
#define __WS_HIGHLIGHTING_H


#include <qarray.h>
#include <qrect.h>
#include <qpoint.h>


class Highlighted
  {
    public:
      Highlighted ();
      ~Highlighted ();

      // is row, col or at least one cell highlighted
      bool isHighlighted (int row, int col);

      // is at least something highlighted?
      bool isHighlighted ();

      // is complete column highlighted but nothing more
      bool isCompleteColumnHighlighted (int col);

      // is at least something of a column highlighted, but not more columns
      bool isColumnHighlighted (int col);

      void setMouseStartPos (QPoint p, char* name);
      void setMouseEndPos (QPoint p);

      // the mousePosition (in cells) on press and release event
      QPoint getMouseEndPos ();
      QPoint getMouseStartPos ();

      // returns the name of the tableview which has started to highlight 
      char* whoHasHighlighted ();

      void setNoHighlight ();

      // return the rectangle that is highlighted (in cells beginning from 0,0)
      int getLeftX ();
      int getUpperY ();
      int getRightX ();
      int getLowerY ();

      QArray<int> getSelectedColumns ();
      QArray<int> getSelectedRows ();
      QRect getSelectedArea ();

      // returns the column that is highlighted, no matter who has highlighted,
      // but only 1 column is allowed to be highlighted
      int getSelectedColumn ();


    private:
      // here the mouseCoordinates will be stored in row and col
      QPoint mouseStartPos;
      QPoint mouseEndPos;

      // gets the name of the widget who started to highlight 
      // the name is identical to the name given in class worksheet
      char* hasHighlighted;
  };


#endif


