c     -*- mode: FORTRAN -*-
c
c     This file is part of krot,
c     a program for the simulation, assignment and fit of HRLIF spectra.
c
c     Copyright (C) 1994-1998 Arnim Westphal
c     Copyright (C) 1997-1999 Jochen Kpper
c
c     If you use this program for your scientific work, please cite it according to
c     the file CITATION included with this package.
c
c     krot-arnirot
c     a program to calculate rotational resolved vibrational/vibronic bands
c
c     this program utilizes the Watson-Hamiltonian up to quartic terms
c     for reference see: James K. G. Watson, Vibrational Spectra and Structure 6, 1 (1977), ed J.R. Durig)


#include "arni.h"


c     main program to calculate two state rovibronic spectra
      program arni

      implicit none

c     maximum (possible) rotational quantum number
      integer        Jmax
      parameter      ( Jmax = ARNIROT_JMAX )

c     maximum dimension of hamiltonian matrix
      integer        dmham
      parameter      ( dmham = 2*Jmax + 1 )
c     dimension of eigenvalue storage vectors
      integer        dmeval
      parameter      ( dmeval = (Jmax + 1)*(Jmax + 1) )
c     number of elements for eigenvector storage, help variable szvec
      integer        dmevec
      real*8         szvec
c     last summand is 1.5 instead of 1.0 to prevent roundoff error
      parameter      ( szvec = ((4.d0/3.d0*Jmax + 4.d0)*Jmax + 11.d0/3.d0)*Jmax + 1.5d0 )
      parameter      ( dmevec = szvec )

c     maximum number of lines
      integer        maxnli
      parameter      ( maxnli = ARNIROT_MAXNLI )
c     maximum number of rotational model parameters (npar each state plus origin)
      integer        npar
      parameter      ( npar = ARNIROT_NPAR )


c     switch for diagonalization algorithm
      integer        diaalg
c     switch for fitting the parameters of ground and/or excited state
      integer        fitges
c     rotational state kets |J Ka Kc>
      integer        icqn(dmeval,3)
c     flag for delta rotational constants
      integer        idelta
c     individual fitting switches for each rotational model parameter
      integer        ifit(2*npar+2)
c     transform transition moment flag
      integer        itrvec
c     pointer on the first element of the eigenvector block of a given J as contained in evec??
      integer        ivpt(0:Jmax)
c     Jmax for calculation
      integer        Jmxcal
c     Jmax for output of matrices
      integer        Jmxout
c     Delta K max
      integer        dKmax
c     set of quantum numbers for a transition
c     lqn  : J', Ka', Kc', J", Ka", Kc"
c     lqn2 : type (1=a, 2=b, 3=c), Ka", Delta Ka, J"-Kc", Delta J, Kc" (old)
c     lqn2 : type (1=a, 2=b, 3=c), Delta J, Delta Ka, Ka", J"-Kc", Kc" (new)
      integer        lqn(maxnli,6), lqn2(maxnli,6)
c     normalization factor for line intensities
      integer        normf
c     number of calculated lines
      integer        ntheli
c     nuclear spin statistical weights  ee eo oe oo
      integer        nuspsw(0:3)
c     maximum number of iterations
      integer        olitmx
c     flag for new IO format
      integer        shorti
c     program status flag
      integer        stflag
c     flags for axis reorientation
      integer        swg, swe


c     intensity cut off
      real*8         cutint
c     divisor for line frequencies
      real*8         divis
c     eigenvalues (final storage)
      real*8         evalg(dmeval),  evale(dmeval)
c     eigenvectors (final storage)
      real*8         evecgr(dmevec), evecer(dmevec)
      real*8         evecgi(dmevec), evecei(dmevec)
c     observed / calculated line positions
      real*8         freexp(maxnli), frethe(maxnli)
c     etalon FSR correction factor
      real*8         fsrcor
c     line intensities
      real*8         intens(maxnli)
c     band origin
      real*8         nuzero
c     transition dipole components
      real*8         polori(3)
c     rotational constants
      real*8         rotcog(npar), rotcoe(npar)
c     common standard deviation for all experimental lines
      real*8         sigma
c     axis SWitching Euler ANGles theta,phi,chi g.s./e.s.
      real*8         swang(3,2)
c     temperatures and weighting factor
      real*8         temp1, weight, temp2


c     branch / parity / axes / symmetry species / logic etc. symbols
c     cf. subroutine setup
      character*1    cBran(-1:1), polax1(3)
      character*2    symdes(0:1,0:1)
      character*3    no_yes(0:1), off_on(0:1)
      character*5    cRotCg(npar), cRotCe(npar), cEuler(3)
      character*7    cState(2)
      character*9    cDRotC(npar), kind(0:1)
      character*10   frame(0:1)
      character*81   lstars, lbars, ldash
      character*220  lngbar
c     file names
      character*250  asfile, lifile


      ARNIROT_LAUNCH( "Starting arni." )

c     reset status flag
      stflag = 0

      call input  ( Jmax, npar,
     *              swg, swe, swang, itrvec,
     *              diaalg,
     *              Jmxcal, dKmax, cutint,
     *              lifile, asfile,
     *              fitges, ifit, sigma,
     *              polori,
     *              shorti,
     *              cRotCg, cRotCe, cDRotC, cState, cEuler, no_yes, off_on,
     *              frame, kind,
     *              cBran, polax1,
     *              symdes,
     *              lngbar, lstars, lbars, ldash,
     *              temp1, temp2, weight, nuspsw,
     *              nuzero,
     *              divis, Jmxout, normf,
     *              rotcog, rotcoe, idelta,
     *              fsrcor, olitmx,
     *              stflag )

      if ( stflag .eq. 2 ) goto 999

      call arnical( Jmax, dmeval, dmevec, maxnli, npar, ntheli, icqn,
     *              swg, swe, swang, itrvec,
     *              diaalg,
     *              evalg, evale,
     *              evecgr, evecgi, evecer, evecei,
     *              Jmxcal, dKmax, cutint,
     *              lifile, asfile,
     *              fitges, ifit, sigma,
     *              polori,
     *              shorti,
     *              cRotCg, cRotCe, cDRotC, cState, cEuler, no_yes, off_on,
     *              frame, kind,
     *              cBran, polax1,
     *              lngbar, lstars, lbars, ldash,
     *              lqn, lqn2, intens, frethe, freexp,
     *              temp1, temp2, weight, nuspsw,
     *              nuzero,
     *              divis, Jmxout, normf,
     *              rotcog, rotcoe, idelta,
     *              ivpt,
     *              fsrcor, olitmx,
     *              stflag )

      if ( stflag .eq. 2 ) goto 999

      call output ( Jmax, dmeval, dmevec, maxnli, npar, ntheli, icqn,
     *              swg, swe, swang, itrvec,
     *              diaalg,
     *              evalg, evale,
     *              evecgr, evecer, evecgi, evecei,
     *              Jmxcal, dKmax, cutint,
     *              lifile, asfile,
     *              fitges, ifit, sigma,
     *              polori,
     *              shorti,
     *              cRotCg, cRotCe, cDRotC, cState, cEuler, no_yes, off_on,
     *              cBran, polax1,
     *              symdes,
     *              lngbar, lstars, lbars, ldash,
     *              lqn, lqn2, intens, frethe, freexp,
     *              temp1, temp2, weight, nuspsw,
     *              nuzero,
     *              divis, Jmxout, normf,
     *              rotcog, rotcoe, idelta,
     *              ivpt,
     *              fsrcor, olitmx,
     *              stflag )

  999 stop
      end
