c     -*- mode: FORTRAN -*-
c
c     This file is part of krot,
c     a program for the simulation, assignment and fit of HRLIF spectra.
c
c     Copyright (C) 1994-1998 Arnim Westphal
c     Copyright (C) 1998,1999 Jochen Kpper


#include "arni.h"

c     output lines information to file or stdout
      subroutine linout( maxnl, ntheli,
     *                   lifile,
     *                   shorti,
     *                   cBran,
     *                   lstars,
     *                   lqn, lqn2, intens, frethe, freexp,
     *                   divis, fsrcor, Jmxout, normf )

      implicit none

      integer        maxnli, maxnl
      parameter      ( maxnli = ARNIROT_MAXNLI )

      integer        i, l
      integer        dKa, dKc
      integer        iop(maxnli)
      integer        iunit
      integer        Jmxout
      integer        lqn(maxnl,6), tmplqn(maxnli,6)
      integer        lqn2(maxnl,6)
      integer        normf
      integer        ntheli
      integer        shorti
      integer        strlen

      real*8         divis
      real*8         intens(maxnl)
      real*8         intmin, intmax
      real*8         freexp(maxnl), frethe(maxnl)
      real*8         fremin, fremax
      real*8         fsrcor
      real*8         tmpexp(maxnli), tmpthe(maxnli), tmpint(maxnli)

      character*1    typ, bra, dKs, dKsymb(-9:9)
      character*1    type(0:2), cBran(-1:1), parity(0:1)
      character*2    mark
      character*4    units(0:10)
      character*81   lstars
      character*250  lifile

#ifdef DEBUG_SUBBRANCH_OUTPUT
      integer        Kag, lKag
      integer        tmplq2(maxnli,6)
      real*8         lfre
      real*8         pqnthe(maxnli)
      character*1    lpar, par
#endif


      ARNIROT_LAUNCH ( "Launching linout." )

      if ( shorti .eq. 0 ) then
c        initialize character variables
         mark       = ' *'
c        type of transition according to selection rules
         type(0)    = 'a'
         type(1)    = 'b'
         type(2)    = 'c'
c        parity
         parity(0)  = 'e'
         parity(1)  = 'o'
c        small letter symbol for Delta Ka
         dKsymb(-9) = 'h'
         dKsymb(-8) = 'i'
         dKsymb(-7) = 'j'
         dKsymb(-6) = 'k'
         dKsymb(-5) = 'l'
         dKsymb(-4) = 'm'
         dKsymb(-3) = 'n'
         dKsymb(-2) = 'o'
         dKsymb(-1) = 'p'
         dKsymb(0)  = 'q'
         dKsymb(1)  = 'r'
         dKsymb(2)  = 's'
         dKsymb(3)  = 't'
         dKsymb(4)  = 'u'
         dKsymb(5)  = 'v'
         dKsymb(6)  = 'w'
         dKsymb(7)  = 'x'
         dKsymb(8)  = 'y'
         dKsymb(9)  = 'z'
c        line frequency unit
         units(0)  = '    '
         units(1)  = 'kHz'
         units(2)  = 'dkHz'
         units(3)  = 'hkHz'
         units(4)  = 'MHz'
         units(5)  = 'dMHz'
         units(6)  = 'hMHz'
         units(7)  = 'GHz'
         units(8)  = 'dGHz'
         units(9)  = 'hGHz'
         units(10) = 'THz'

c        temporarily store lines data for sorting
         call rvcpy( tmpint, intens, maxnli, ntheli )
         call rvcpy( tmpexp, freexp, maxnli, ntheli )
         call rvcpy( tmpthe, frethe, maxnli, ntheli )
         call imcpy( tmplqn, lqn,    maxnli, 6, ntheli, 6 )
#ifdef DEBUG_SUBBRANCH_OUTPUT
         call imcpy( tmplq2, lqn2,   maxnli, 6, ntheli, 6 )
#endif

c        loop through the lines to associate an ordering pointer with each line
         do i = 1, ntheli, 1
            iop(i) = i
         end do

c        sort the frequencies into DESCENDING order
         call sort2d( ntheli, frethe, iop )

c        now exchange the theoretical lines information back according to iop order
         call rvcpyo( intens, tmpint, iop, maxnli, ntheli )
         call rvcpyo( frethe, tmpthe, iop, maxnli, ntheli )
         call rvcpyo( freexp, tmpexp, iop, maxnli, ntheli )
         call imcpyo( lqn,    tmplqn, iop, maxnli, 6, ntheli, 6 )
#ifdef DEBUG_SUBBRANCH_OUTPUT
         call imcpyo( lqn2,   tmplq2, iop, maxnli, 6, ntheli, 6 )
#endif

c        save lowest and highest frequencies and intensities separately
         fremin = frethe(ntheli) / divis
         fremax = frethe(1) / divis
         intmin = intens(1) * normf
         intmax = intens(1) * normf

         do i = 1, ntheli, 1
c           apply intensity normalization factor
            intens(i) = intens(i) * normf
c           determine range of normalized intensities
            if ( intens(i) .lt. intmin ) intmin = intens(i)
            if ( intens(i) .gt. intmax ) intmax = intens(i)
c           apply ASYROT compatibility divisor to theoretical frequencies
            frethe(i) = frethe(i) / divis
         end do

c        output lines information to file
         open(11, file = lifile(1:strlen(lifile)), status = 'unknown')
         do i = 1, ntheli, 1
c           determine Delta Ka, corresponding symbol, and Delta Kc
            dKa = lqn(i,2) - lqn(i,5)
            dKc = lqn(i,3) - lqn(i,6)
            dKs = dKsymb(dKa)
c           determine type and branch of transition
#ifdef DEBUG_SUBBRANCH_OUTPUT
            typ = type(lqn2(i,1))
            bra = cBran(lqn2(i,2) - 1)
#else
            typ = type(mod(iabs(dKa),2) - mod(iabs(dKc),2) + 1)
            bra = cBran(lqn(i,1) - lqn(i,4))
#endif
            if ( freexp(i) .ne. 0 ) then
c              correct and reconvert experimental frequencies
               freexp(i) = freexp(i) * fsrcor / divis
               write(11,240) typ,dKs,bra,lqn(i,5),lqn(i,4)-lqn(i,6),(lqn(i,l),l=1,6),intens(i),frethe(i),freexp(i),frethe(i)-freexp(i),mark
            else
               write(11,240) typ,dKs,bra,lqn(i,5),lqn(i,4)-lqn(i,6),(lqn(i,l),l=1,6),intens(i),frethe(i)
            end if
  240       format(a2, a3, a1, i2, ',J-', i2, 1x, 6(i4), f11.3, 2(f18.6), f13.6, a2)
c 240       format(a2, a3, a1, i2, ',J-', i2, 1x, 6(i4), 3(1x,f18.6), 1x, f13.6)
         end do
         close(11)

#ifdef DEBUG_SUBBRANCH_OUTPUT
c        generate another lines file: arrange transitions according to subbranch type
c        temporarily store lines data for sorting
         call rvcpy( tmpint, intens, maxnli, ntheli )
         call rvcpy( tmpexp, freexp, maxnli, ntheli )
         call rvcpy( tmpthe, frethe, maxnli, ntheli )
         call imcpy( tmplqn, lqn,    maxnli, 6, ntheli, 6 )
         call imcpy( tmplq2, lqn2,   maxnli, 6, ntheli, 6 )

c        loop through the lines to associate an ordering pointer with each line
         do i = 1, ntheli, 1
            iop(i) = i
         end do

c        restructure theoretical lines set in terms of packed information
         call qnpac2( pqnthe, lqn2, maxnli, ntheli )
c        sort the lines by packed quantum number lqn2 into ASCENDING order
         call sort2a( ntheli, pqnthe, iop )

c        now exchange the theoretical lines information back according to iop order
         call rvcpyo( intens, tmpint, iop, maxnli, ntheli )
         call rvcpyo( frethe, tmpthe, iop, maxnli, ntheli )
         call rvcpyo( freexp, tmpexp, iop, maxnli, ntheli )
         call imcpyo( lqn,    tmplqn, iop, maxnli, 6, ntheli, 6 )
         call imcpyo( lqn2,   tmplq2, iop, maxnli, 6, ntheli, 6 )

c        output lines information
         open(11, file = lifile(1:strlen(lifile))//'.sbr', status = 'unknown')
         par = 'x'
         Kag = 0
         lfre = 0.d0
         do i = 1, ntheli, 1
            lpar = par
            lKag = Kag
c           determine Delta Ka and corresponding symbol
            Kag = lqn(i,5)
            dKa = lqn(i,2) - Kag
            dKs = dKsymb(dKa)
c           determine type of transition
            typ = type(lqn2(i,1))
c           determine the branch type for this transition (old version: (i,5))
            bra = cBran(lqn2(i,2) - 1)
c           determine parity of the initial level
            par = parity(mod((lqn(i,4) + lqn(i,5) + lqn(i,6)),2))

            if ( ( par .ne. lpar ) .or. ( Kag .ne. lKag ) ) then
               write(11,*) ' '
               lfre = frethe(i)
            end if
            write(11,340) typ,dKs,bra,lqn(i,5),lqn(i,4)-lqn(i,6),(lqn(i,l),l=1,6),intens(i),frethe(i),frethe(i)-lfre
  340       format(a2, a3, a1, i2, ',J-', i2, 1x, 6(i4), f11.3, f18.6, f13.6)
c 340       format(a2, a3, a1, i2, ',J-', i2, 1x, 6(i4), 2(1x,f18.6), 1x, f11.6)
            lfre = frethe(i)
         end do
         close(11)
#endif

c        output information about the range of values
c        determine abscissa unit
         iunit = 0
         do i = 1, 10, 1
            if ( dlog10( dble( divis ) ) + 4.d0 .eq. dble( i ) ) iunit = i
         end do

         write(*,'(a)') lstars
         write(*,*) 'report on stick spectrum'
         write(*,'(a)') lstars
         write(*,'(''range of frequencies:'',19x,''range of normalized intensities:'',/)')
         write(*,'(''minimum  '',f17.6,1x,a4,9x,''minimum  '', f10.3 )') fremin, units(iunit), intmin
         write(*,'(''maximum  '',f17.6,1x,a4,9x,''maximum  '', f10.3 )') fremax, units(iunit), intmax
         write(*,'(/,''total spectrum width       :'',f17.6,1x,a4)') fremax - fremin, units(iunit)
         write(*,'(/,''number of calculated lines :'',i10)') ntheli

      else

c        output lines information to stdout
         do i = 1, ntheli, 1
            write(*,*) (lqn(i,l),l=1,6),intens(i),frethe(i)
         end do

      end if

      return
      end


c------------------------------------------------------------------------------
#ifdef DEBUG_SUBBRANCH_OUTPUT
c     pack additional line information
      subroutine qnpac2( pqn, lqn2, maxnl, nlines )

      implicit none

      integer        maxnl
      integer        i, nlines
      integer        lqn2(maxnl,6)
      real*8         pqn(maxnl)

      ARNIROT_LAUNCH ( "Launching qnpac2." )

      do i = 1, nlines, 1
c        old version:
c        corrected for Jmax < 1000: ABBBCCC.dddefff
c                                   tKa"dKa dKJdJKc"
c        pqn(i) = lqn2(i,1)*1.d6 + lqn2(i,2)*1.d3 + lqn2(i,3)*1.d0 + lqn2(i,4)*1.d-3 + lqn2(i,5)*1.d-4 + lqn2(i,6)*1.d-7
c        new version (08.09.98):
c        corrected for Jmax < 1000: ABCCC.dddeeefff
c                                   tdJdKaKa"dKJKc"
         pqn(i) = lqn2(i,1)*1.d4 + lqn2(i,2)*1.d3 + lqn2(i,3)*1.d0 + lqn2(i,4)*1.d-3 + lqn2(i,5)*1.d-6 + lqn2(i,6)*1.d-9
      end do

      return
      end
#endif
