// -*- mode: C++; c-file-style: "Stroustrup" -*-
//
// This file is part of krot,
// a program for the simulation, assignment and fit of HRLIF spectra.
//
// Copyright (C) 1998,1999 Jochen Kpper
//



#include <cstdio>
#include <cstdlib>



/**
 * Convert FORTRAN string to zero terminated char[] and run the resulting
 * C string through libc - atoi.
 *
 * @author Jochen Kpper
 * @version 1998/09/23
 */
extern "C" int atoi_( char *fl )
{
    int n = 0;
    // determin length of string
    while( ( '\f' != fl[ n ] ) )
	n++;
    char cl[ n + 1 ];
    for( int i=0; i<n; i++)
	cl[ i ] = fl[ i ];
    cl[ n ] = 0; 
    return atoi( cl );
}



/**
 * Convert FORTRAN string to zero terminated char[] and run the resulting
 * C string through libc - atof.
 *
 * @author Jochen Kpper
 * @version 1998/09/23
 */
extern "C" double atof_( char *fl )
{
    int n = 0;
    // determin length of string
    while( ( '\f' != fl[ n ] ) )
	n++;
    char cl[ n + 1 ];
    for( int i=0; i<n; i++)
	cl[ i ] = fl[ i ];
    cl[ n ] = 0; 
    return atof( cl );
}



/**
 * Print given string to stderr
 *
 * @author Jochen Kpper
 * @version 1998/09/23
 */
extern "C" void warn_( char *format )
{
    fprintf( stderr, format );
    return;
}



/**
 * Print given string to stderr and exit the program
 *
 * @author Jochen Kpper
 * @version 1998/09/23
 */
extern "C" void error_( char *format )
{
    fprintf( stderr, format );
    exit( 1 );
    return;
}
