// -*- mode: C++; c-file-style: "Stroustrup" -*-
//
// This file is part of krot,
// a program for the simulation, assignment and fit of HRLIF spectra.
//
// Copyright (C) 1998,1999 Jochen Kpper
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; see the file License. if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 , USA
//
// If you use this program for your scientific work, please cite it according to
// the file CITATION included with this package.
//



#include "progress.h"

#include <iostream.h>

#include <qdialog.h>
#include <qlabel.h>
#include <qlayout.h>

#include <kapp.h>
#include <kbuttonbox.h>
#include <klocale.h>
#include <kprogress.h>



DialogProgress::DialogProgress( QWidget *parent, const char *caption, const char *text, int val, int min, int max )
    : QDialog( parent, 0, true, 1036288 ) // non-modal dialog
{
#ifdef LAUNCH
    cerr << "Launching DialogProgress constructor" << endl;
#endif
    setCaption( caption );
    
    QBoxLayout *layout = new QVBoxLayout( this );
    QBoxLayout *layout2 = new QHBoxLayout();
    QBoxLayout *layout3 = new QHBoxLayout();
    layout->addSpacing( 10 );
    layout->addLayout( layout2 );
    layout->addSpacing( 20 );
    layout->addLayout( layout3 );

    QLabel *label = new QLabel( text, this );
    label->setAlignment( AlignCenter );
    label->setFixedHeight( label->sizeHint().height() );
    layout2->addSpacing( 10 );
    layout2->addWidget( label );
    layout2->addSpacing( 10 );

    progress = new KProgress( min, max, min, KProgress::Horizontal, this, "progress" );
    progress->setBarStyle( KProgress::Solid );
    layout3->addSpacing( 20 );
    layout3->addWidget( progress );
    layout3->addSpacing( 20 );

    KButtonBox *bbox = new KButtonBox( this );
    bbox->addStretch( 5 );
    QPushButton *button = bbox->addButton( i18n( "Cancel" ) );
    bbox->addStretch( 5 );
    bbox->layout();
    layout->addWidget( bbox, 1 );
    
    layout->activate();
    setGeometry( x(), y(), label->sizeHint().width() + 20, 150 );
    
    connect( button, SIGNAL( pressed() ),
	     this, SLOT(cancel()) );
    return;
}



void DialogProgress::cancel()
{
    emit abort();
    reject();
    return;
}



void DialogProgress::setValue( int val )
{
    progress->setValue( val );
    return;
}
