/*============================================================================*/
/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> LSF_IAR.C <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/
/*============================================================================*/
#include 	 	"com_iar.h"


short LsfTrs( void ) ;
short Ham2Trs( void ) ;
void PrntPrm( void ) ;
short svdfit( double *x, double *y, long ndata, double *a, long ma, long *lista, long mfit, double **u, double **v, double *w, double *chisq, double *funcs, double *sig ) ;
short svdvar( double **v, long mfit, double *w, double **cvm ) ;
short GenLnSet( long prm_no, double *prm ) ;
void LsfPrntPrm( long i_ct, long f_ct, long *fit_idx, long *str_idx, double *prm, double *prm_old, double *prm_std ) ;

short DAlloc1Dim( double **ptpt, long sz ) ;
void DFree1Dim( double **ptpt ) ;
short DAlloc2Dim( double ***ptptpt, long sz1, long sz2 ) ;
void DFree2Dim( double ***ptptpt, long sz1 ) ;


/*WEIGHTING FACTORS THE UV AND MW DATA (MHZ) FOR FITTING ROUTINE*/
double Lsf_UVwt, Lsf_MWwt ;
short Dual_Fit ;
extern long Asn_split ;
long asn_split ;




/*LINEAR LEAST SQUARES FIT TO OBSERVED TRANSITION ENERGIES*/
short LsfTrs()
   {
   short ecyc_ct, acyc_ct ;
   int lf_fd, re_fd ;
   long cnt, cts, fit_ct, nofit_ct ;
   long prm_no, acp_nolvs, acp_ct, acp_ofs, ee_idx ;
   long fit_idx[ ST_NO * ST_NOPARORI ], str_idx[ ST_NO * ST_NOPARORI ] ;
   long dvs_no, dvs_sz, row_ofs ;
   double obl_erg, cal_erg ;
   double prm[ ST_NO * ST_NOPARORI ], prm_old[ ST_NO * ST_NOPARORI ], prm_std[ ST_NO * ST_NOPARORI ] ;
   double **cvar_mat, omc, chi_sq ;
   double *obln_vec, *wts_vec, *dvs_mat, **u_mat, **v_mat, *w_vec, erg ;

   double origin ;


/*LOOP THROUGH ALL GROUND AND EXCITED STATE PARAMETERS -> REASSIGN TO SINGLE ARRAY*/
   for( prm_no = 0, fit_ct = 0, nofit_ct = Lsf_noprm, cnt = 0; cnt < ST_NO; cnt++ )
      {
      for( cts = 0; cts < ST_NOPAR + cnt; cts++ )
         {

      /*PARAMETER STATUS ACTIVE -> REASSIGN TO SINGLE DIMENSIONAL VECTOR*/
         if( Rc_stat[ cnt ][ cts ] )
            {

         /*REASSIGN TO PARAMETER VECTOR -> SAVE OLD PARMETERS*/
            prm[ ++prm_no ] = Rc[ cnt ][ cts ] ;
            prm_old[ prm_no ] = prm[ prm_no ] ;

         /*FIT STATUS ACTIVE -> ASSIGN INDEX AND DETERMINE # OF PARAMETERS TO FIT*/
            if( Lsf_stat[ cnt ][ cts ] )
               fit_idx[ ++fit_ct ] = prm_no ;

         /*FIT STATUS NOT ACTIVE -> ASSIGN INDEX TO LATTER PART OF VECTOR*/
            else
               fit_idx[ ++nofit_ct ] = prm_no ;

         /*ROTATIONAL CONSTANT LBL INDEX*/
            str_idx[ prm_no ] = cts + 1 ;
            if( !cnt )
               str_idx[ prm_no ] *= -1 ;
            }
         }
      }




/*TOTAL # OF DERIVATIVES EXCLUDING ORIGIN DERIVATIVE*/
   dvs_no = prm_no - 1 ;



/*ALLOCATE WORK SPACE FOR LEAST SQUARES ROUTINE*/
   v_mat = NULL ;
   if( DAlloc2Dim( &v_mat, prm_no + 1, prm_no + 1 ) == -1 )
      {
      fprintf( Log_fp, "\nLSFTRS (V_MAT) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( E_RT_UNK ) ;
      }

/*ALLOCATE WORK SPACE FOR LEAST SQUARES ROUTINE*/
   w_vec = NULL ;
   if( DAlloc1Dim( &w_vec, prm_no + 1 ) == -1 )
      {
      fprintf( Log_fp, "\nLSFTRS (W_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( E_RT_UNK ) ;
      }

/*ALLOCATE SPACE FOR 2 DIMENSIONAL COVARIANCE MATRIX*/
   cvar_mat = NULL ;
   if( DAlloc2Dim( &cvar_mat, prm_no + 1, prm_no + 1 ) == -1 )
      {
      fprintf( Log_fp, "\nLSFTRS (CVAR_MAT) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( E_RT_UNK ) ;
      }




/*LOG PARAMETERS TO BE VARIED*/
   fprintf( Log_fp, "%ld PARAMETERS TO BE VARIED\n\n", fit_ct ) ;
   LsfPrntPrm( (long)1, fit_ct, fit_idx, str_idx, (double *)NULL, (double *)NULL, (double *)NULL ) ;

/*LOG PARAMETERS HELD FIXED*/
   fprintf( Log_fp, "\n%ld PARAMETERS HELD FIXED\n\n", prm_no - fit_ct ) ;
   LsfPrntPrm( fit_ct + 1, prm_no, fit_idx, str_idx, (double *)NULL, (double *)NULL, (double *)NULL ) ;

/*LOG INITIAL PARAMETERS*/
   fprintf( Log_fp, "========================================" ) ;
   fprintf( Log_fp, "========================================\n" ) ;
   fprintf( Log_fp, "                              INITIAL PARAMETERS !\n" ) ;
   PrntPrm() ;
   fprintf( Log_fp, "\n\n" ) ;





/*EXACT CYCLE LEAST SQUARES BY REDIAGONALIZING HAMILTONIAN MATRIX AND CALCULATING NEW DERIVATIVES*/
   for( Lsflc_stat = 0, ecyc_ct = 1; ecyc_ct <= Lsf_ecycs; ecyc_ct++ )
      {

   /*LOG CYCLE*/
      fprintf( Log_fp, "========================================" ) ;
      fprintf( Log_fp, "========================================\n" ) ;
      fprintf( Log_fp, "                             EXACT ENERGY CYCLE # %hd\n", ecyc_ct ) ;



   /*SET LAST CYCLE STAT FLAG TO WRITE LINESET INFORMATION IN PHASE III*/
      if( ecyc_ct == Lsf_ecycs )
         Lsflc_stat = 1 ;

   /*CALCULATE AND DIAGONALIZE HAMILTONIAN MATRIX + CALCULATE DERIVATIVES AND TRANSITION ENERGIES*/
      if( Ham2Trs() == E_RT_UNK )
         return( E_RT_UNK ) ;

   /*DUAL FIT - BOTH MICROWAVE AND UV DATA FIT*/
      if( Dual_Fit )
         {
         origin = Rc[ EXE ][ ORI ] ;
         Rc[ EXE ][ ORI ] = 0.0 ;

         if( Ham2Trs() == E_RT_UNK )
            return( E_RT_UNK ) ;

         Rc[ EXE ][ ORI ] = origin ;
         }


   /*ALLOCATE SPACE FOR OBSERVED ENERGY VECTOR*/
      obln_vec = NULL ;
      if( DAlloc1Dim( &obln_vec, Acp_nolvs + 1 ) == -1 )
         {
         fprintf( Log_fp, "\nLSFTRS (OBLN_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
         return( E_RT_UNK ) ;
         }

   /*ALLOCATE SPACE FOR WEIGHT VECTOR*/
      wts_vec = NULL ;
      if( DAlloc1Dim( &wts_vec, Acp_nolvs + 1 ) == -1 )
         {
         fprintf( Log_fp, "\nLSFTRS (WTS_VEC) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
         return( E_RT_UNK ) ;
         }

   /*ALLOCATE SPACE FOR DERIVATIVE MATRIX*/
      dvs_mat = NULL ;
      if( DAlloc1Dim( &dvs_mat, (Acp_nolvs + 1) * (prm_no + 1) ) == -1 )
         {
         fprintf( Log_fp, "\nLSFTRS (DVS_MAT) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
         return( E_RT_UNK ) ;
         }

   /*ALLOCATE SPACE FOR OBSERVED ENERGY VECTOR*/
      u_mat = NULL ;
      if( DAlloc2Dim( &u_mat, Acp_nolvs + 1, prm_no + 1 ) == -1 )
         {
         fprintf( Log_fp, "\nLSFTRS (U_MAT) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
         return( E_RT_UNK ) ;
         }



   /*OPEN FILE CONTAINING LSF INFORMATION*/
      if( (lf_fd = open( "IAR.lf", O_RDONLY | O_BINARY ) ) == -1 )
         {
         fprintf( Log_fp, "\nLSFTRS -> CAN'T OPEN 'IAR.lf' FILE !\n" ) ;
         return( E_RT_UNK ) ;
         }

   /*CREATE FILE CONTAINING REJECTED LINE INDEX INFORMATION*/
      if( (re_fd = open( "IAR.re", O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666) ) == -1 )
         {
         fprintf( Log_fp, "\nLSFTRS -> CAN'T CREATE 'IAR.re' FILE !\n" ) ;
         return( E_RT_UNK ) ;
         }





   /*INITIALLY SET SPLIT POINT AS IN ORIGINAL*/
      asn_split = Asn_split ;

   /*CALCULATE TOTAL BYTES PER LINE IN IAR.lf FILE*/
      dvs_sz = sizeof( long ) + (dvs_no + 2) * sizeof( double ) ;

   /*LOOP THROUGH ALL OBSERVED LINES AND REJECT THOSE EXCEEDING REJECTION LEVEL*/
      for( chi_sq = 0.0, acp_nolvs = 0, cnt = 1; cnt <= Acp_nolvs; cnt++ )
         {

      /*READ INDEX INTO LINESET ARRAY -> USED TO INDEX AND LABEL REJECTED LINES -> BREAK ON EOF*/
         if( read( lf_fd, (char *)&ee_idx, sizeof( long ) ) == 0 )
            {
            fprintf( Log_fp, "\nLSFTRS -> PREMATURE EOF IN 'IAR.lf' FILE ! %ld\n", acp_nolvs ) ;
            break ;
            }

      /*READ CALCULATED ENERGY*/
         read( lf_fd, (char *)&cal_erg, sizeof( double ) ) ;

      /*READ OBSERVED ENERGY*/
         read( lf_fd, (char *)&obl_erg, sizeof( double ) ) ;




      /*ACCEPT LINE -> OBSERVED MINUS CALCULATED SMALLER THAN REJECTION LEVEL*/
         if( (omc = fabs( obl_erg - cal_erg )) < Lsf_rejlv )
            {


         /*ACCUMULATE CHI SQUARED*/
            chi_sq += omc * omc ;

         /*INCREAMENT ACCEPTED LINE COUNT AND ASSIGN TO DOUBLE VECTOR*/
            obln_vec[ ++acp_nolvs ] = obl_erg ;

         /*READ ALL DERIVATIVE INFORMATION INTO MATRIX*/
            read( lf_fd, (char *)(dvs_mat + acp_nolvs * (prm_no + 1) + 1), dvs_no * sizeof( double ) ) ;


         /*ASSIGN DERIVATIVE OF ORIGIN AS ONE AND WEIGHT UV/MW DATA*/
            if( acp_nolvs <= asn_split && Rc[ EXE ][ ORI ] )
               {
               *(wts_vec + acp_nolvs) = Lsf_UVwt ;
               *(dvs_mat + acp_nolvs * (prm_no + 1) + 1 + dvs_no) = 1.0 ;

            /*TELL USER WEIGHT OF UV DATA*/
               if( acp_nolvs == asn_split )
                  printf( "UV WEIGHT = %f, LAST LEVEL # = %ld\n", Lsf_UVwt, acp_nolvs ) ;
               }

         /*ASSIGN DERIVATIVE OF ORIGIN AS ONE AND WEIGHT MW DATA - MUST ALWAYS BE SECOND IN ASSIGNMENT FILE*/
            else
               {
               *(wts_vec + acp_nolvs) = Lsf_MWwt ;
               *(dvs_mat + acp_nolvs * (prm_no + 1) + 1 + dvs_no) = 0.0 ;

            /*TELL USER WEIGHT OF MW DATA*/
               if( acp_nolvs == asn_split + 1 )
                  printf( "MW WEIGHT = %f, FIRST LEVEL # = %ld\n", Lsf_MWwt, acp_nolvs ) ;
               }


         /*ERROR ANALYSIS*/
            if( Err == 4 )
               {

            /*CALCULATE NEW ENERGIES - LOOP THROUGH ALL OLD DERIVATIVES AND NEW PARAMETERS*/
               for( erg = 0.0, row_ofs = acp_nolvs * (prm_no + 1), cts = 1; cts <= prm_no; cts++ )
                  erg += prm[ cts ] * *(dvs_mat + row_ofs + cts) ;

               printf( "\n\nCAL %f OBS %f CAL %f", erg, obln_vec[ acp_nolvs ], cal_erg ) ;
               printf( "\nOMC[ %ld ] = %f CHI_SQ = %f", acp_nolvs, omc, chi_sq ) ;

               printf( "\nOMC = %f DERIVATIVES = :\n", obl_erg - cal_erg ) ;
               for( cts = 1; cts <= prm_no; cts++ )
                  printf( "%.4f ", *(dvs_mat + acp_nolvs * (prm_no + 1) + cts) ) ;
               fflush( stdout ) ;
               }
            }


      /*WRITE INDEX OF REJECTED LINE*/
         else
            {
            write( re_fd, (char *)&ee_idx, sizeof( long ) ) ;
            if( acp_nolvs <= Asn_split )
               asn_split-- ;
            }


      /*SET FILE POINTER TO NEXT CALCULATED ENERGY -> REJECTED LINE DERIVATIVES NOT READ*/
         lseek( lf_fd, (long)cnt * dvs_sz, 0 ) ;
         }


   /*CLOSE REJECTED LINE INDEX FILE AND LSF FILE*/
      close( re_fd ) ;
      close( lf_fd ) ;




   /*LOG INITIAL PARAMETERS*/
      fprintf( Log_fp, "----------------------------------------" ) ;
      fprintf( Log_fp, "----------------------------------------\n" ) ;
      fprintf( Log_fp, "                             INITIAL STATISTICS !\n" ) ;
      fprintf( Log_fp, "----------------------------------------" ) ;
      fprintf( Log_fp, "----------------------------------------\n" ) ;
      fprintf( Log_fp, "OMC REJECTION LEVEL =%9.2f", Lsf_rejlv ) ;
      fprintf( Log_fp, "                       ASN LINES ACCEPTED  =%6ld\n", acp_nolvs ) ;

   /*ZERO CHECK ON DEMONINATOR - CALCULATE AND LOG STANDARD DEVIATION OF OBSERVED MINUS CALCULATED*/
      if( (Rej_nolvs = Acp_nolvs - acp_nolvs) != Acp_nolvs )
         {
         Omc_stdv = (float)sqrt( chi_sq / acp_nolvs ) ;
         fprintf( Log_fp, "OMC STD DEV         =%9.4f", Omc_stdv ) ;
         fprintf( Log_fp, "                       ASN LINES REJECTED  =%6ld\n", Rej_nolvs ) ;
         }





   /*APPROXIMATE CYCLE LEAST SQUARES UTILIZING NEW PARAMETERS AND OLD DERIVATIVES*/
      for( acyc_ct = 1; acyc_ct <= Lsf_acycs; acyc_ct++ )
         {


      /*RETURN -> NOT ENOUGH OBSERVED LINES*/
         if( acp_nolvs < fit_ct )
            {

         /*LOG ERROR MESSAGE*/
            fprintf( Log_fp, "NUMBER OF ASSIGNED LINES [%ld] MUST BE >= ", acp_nolvs ) ;
            fprintf( Log_fp, "NUMBER OF PARAMETERS TO FIT [%ld] !\n", fit_ct ) ;

         /*FREE SPACE*/
            DFree1Dim( &obln_vec ) ;
            DFree1Dim( &wts_vec ) ;
            DFree1Dim( &dvs_mat ) ;
            DFree2Dim( &u_mat, Acp_nolvs + 1 ) ;
            DFree2Dim( &v_mat, prm_no + 1 ) ;
            DFree1Dim( &w_vec ) ;
            DFree2Dim( &cvar_mat, prm_no + 1 ) ;

         /*RETURN FAILURE*/
            return( E_RT_NOL ) ;
            }




      /*NUMERICAL RECIPES LINEAR LEAST SQUARES ROUTINE*/
         if( svdfit( (double *)NULL, obln_vec, acp_nolvs, prm, prm_no, fit_idx, fit_ct, u_mat, v_mat, w_vec, &chi_sq, dvs_mat, wts_vec ) == -1 )
            return( E_RT_UNK ) ;




      /*LOOP THROUGH ALL ACCEPTED LEVELS CHECK OMC USING OLD DERIVATIVES -> ALL ARRAYS UNIT OFFSET*/
         for( acp_ct = 0, chi_sq = 0.0, cnt = 1; cnt <= acp_nolvs; cnt++ )
            {


         /*CALCULATE NEW ENERGIES - LOOP THROUGH ALL OLD DERIVATIVES AND NEW PARAMETERS*/
            for( erg = 0.0, row_ofs = cnt * (prm_no + 1), cts = 1; cts <= prm_no; cts++ )
               erg += prm[ cts ] * *(dvs_mat + row_ofs + cts) ;


         /*ERROR ANALYSIS*/
            if( Err == 4 )
               {
               printf( "\nDVS[ %ld ] = %f PRM = %f", cts-1, *(dvs_mat + row_ofs + cts-1), prm[ cts-1 ] ) ;
               printf( "\nCNT = %ld ERG = %f OBLN = %f", cnt, erg, *(obln_vec + cnt) ) ;
               }


         /*ASSIGNED LINE STILL ACCEPTED -> OMC SMALLER THAN REJECTION LEVEL*/
            if( (omc = fabs( *(obln_vec + cnt) - erg )) < Lsf_rejlv )
               {

            /*ACCUMULATE CHI SQUARED*/
               chi_sq += omc * omc ;

            /*SHIFT DERIVATIVES AND ENERGY TO LOWEST ACCEPTED SLOT IN ARRAYS*/
               if( cnt != ++acp_ct )
                  {
                  printf( "SHIFTED %ld %ld\n", cnt, acp_ct ) ;

               /*SHIFT DERIVATIVES DOWN IN MATRIX -> UNIT OFFSET MATRIX IN BOTH DIMENSIONS*/
                  for( acp_ofs = acp_ct * (prm_no + 1), cts = 1; cts <= prm_no; cts++ )
                     *(dvs_mat + acp_ofs + cts) = *(dvs_mat + row_ofs + cts) ;

               /*SHIFT OBSERVED LINE ENERGY AND WEIGHT -> UNIT OFFSET VECTOR*/
                  *(obln_vec + acp_ct) = *(obln_vec + cnt) ;
                  *(wts_vec + acp_ct) = *(wts_vec + cnt) ;
                  }
               }

            else
               {
               if( acp_ct <= asn_split )
                  asn_split-- ;
               }
            }





      /*LOG CYCLE*/
         fprintf( Log_fp, "----------------------------------------" ) ;
         fprintf( Log_fp, "----------------------------------------\n" ) ;
         fprintf( Log_fp, "    REJECTION CYCLE %hd PARAMETERS", acyc_ct ) ;
         fprintf( Log_fp, " => OLD, NEW, OLD - NEW, STANDARD DEVIATION\n" ) ;
         fprintf( Log_fp, "----------------------------------------" ) ;
         fprintf( Log_fp, "----------------------------------------\n" ) ;

      /*CALCULATE COVARIANCES FOR FIT PARAMETERS*/
         if( svdvar( v_mat, fit_ct, w_vec, cvar_mat ) == -1 )
            return( E_RT_UNK ) ;

      /*CALCULATE STANDARD DEVIATIONS FOR EACH PARAMETER*/
         for( cts = 1; cts <= prm_no; cts++ )
            prm_std[ fit_idx[ cts ] ] = sqrt( fabs( cvar_mat[ cts ][ cts ] ) ) ;

      /*LOG INITIAL PARAMETERS AND NEW PARAMETERS*/
         LsfPrntPrm( 1, fit_ct, fit_idx, str_idx, prm, prm_old, prm_std ) ;

      /*CALCULATE AND LOG NEW STANDARD DEVIATION OF OBSERVED MINUS CALCULATED*/
         if( (Rej_nolvs = Acp_nolvs - acp_ct) != Acp_nolvs )
            {
            Omc_stdv = (float)sqrt( chi_sq / acp_ct ) ;
            fprintf( Log_fp, "----------------------------------------" ) ;
            fprintf( Log_fp, "----------------------------------------\n" ) ;
            fprintf( Log_fp, "OMC REJECTION LEVEL =%9.2f", Lsf_rejlv ) ;
            fprintf( Log_fp, "                       ASN LINES ACCEPTED  =%6ld\n", acp_ct ) ;
            fprintf( Log_fp, "OMC STD DEV         =%9.4f", Omc_stdv ) ;
            fprintf( Log_fp, "                       ASN LINES REJECTED  =%6ld\n", Rej_nolvs ) ;
            fprintf( Log_fp, "----------------------------------------" ) ;
            fprintf( Log_fp, "----------------------------------------\n" ) ;
            }


      /*STOP CYCLING WHEN # OF ACCEPTED LINES DOES NOT CHANGE BASED ON OMC OF NEW PAR AND OLD DER*/
         if( acp_nolvs == acp_ct )
            {
            fprintf( Log_fp, "REJECTION CYCLE EXIT -> NO REJECTS BASED ON NEW PARAMETERS " ) ;
            fprintf( Log_fp, "AND OLD DERIVATIVES !\n" ) ;
            fprintf( Log_fp, "========================================" ) ;
            fprintf( Log_fp, "========================================\n\n\n" ) ;
            fflush( Log_fp ) ;

         /*UPDATE # OF ACCEPTED LEVELS FOR NEXT LSF CYCLE - REDUNDANT*/
            acp_nolvs = acp_ct ;

         /*BREAK FROM LOOP*/
            break ;
            }

      /*LOG NEW LINE*/
         else
            fprintf( Log_fp, "\n" ) ;


      /*UPDATE # OF ACCEPTED LEVELS FOR NEXT LSF CYCLE*/
         acp_nolvs = acp_ct ;
         }



   /*ASSIGN NEW PARAMETERS TO GLOBAL TWO DIMENSIONAL MATRIX FOR OTHER PHASES TO ACCESS*/
      for( cnt = cts = 0, acyc_ct = 1;
            acyc_ct <= fit_ct; (cts == ST_NOPAR + cnt) ? (cnt++, cts = 0) : cts++ )
         if( Rc_stat[ cnt ][ cts ] && Lsf_stat[ cnt ][ cts ] )
            {

         /*RETURN AND EXIT PROGRAM WHEN PRINCIPAL MOMENT CONSTANTS BECOMES NEGATIVE*/
            if( (Rc[ cnt ][ cts ] = prm[ fit_idx[ acyc_ct++ ] ]) < 0.0 && cts < 3 )
               {
               fprintf( Log_fp, "\nLSFTRS -> NEGATIVE ROTATION CONSTANT PRODUCED !\n" ) ;

            /*FREE SPACE*/
               DFree1Dim( &obln_vec ) ;
               DFree1Dim( &wts_vec ) ;
               DFree1Dim( &dvs_mat ) ;
               DFree2Dim( &u_mat, Acp_nolvs + 1 ) ;
               return( E_RT_NRC ) ;
               }
            }



   /*FREE SPACE*/
      DFree1Dim( &obln_vec ) ;
      DFree1Dim( &wts_vec ) ;
      DFree1Dim( &dvs_mat ) ;
      DFree2Dim( &u_mat, Acp_nolvs + 1 ) ;
      }




/*PRINT FINAL PARAMETERS*/
   fprintf( Log_fp, "========================================" ) ;
   fprintf( Log_fp, "========================================\n" ) ;
   fprintf( Log_fp, "                                FINAL PARAMETERS !\n" ) ;
   PrntPrm() ;

/*REASSIGN TOTAL # OF ACCEPTED LEVELS TO GLOBAL VARIABLE*/
   Acp_nolvs = acp_nolvs ;

/*LOG STANDARD DEVIATION OF OBSERVED MINUS CALCULATED*/
   fprintf( Log_fp, "OMC REJECTION LEVEL =%9.2f", Lsf_rejlv ) ;
   fprintf( Log_fp, "                       ASN LINES ACCEPTED  =%6ld\n", Acp_nolvs ) ;
   fprintf( Log_fp, "OMC STD DEV         =%9.4f", Omc_stdv ) ;
   fprintf( Log_fp, "                       ASN LINES REJECTED  =%6ld\n", Rej_nolvs ) ;
   fprintf( Log_fp, "========================================" ) ;
   fprintf( Log_fp, "========================================\n\n\n" ) ;




/*CALCULATE COVARIANCES FOR FIT PARAMETERS*/
   if( svdvar( v_mat, fit_ct, w_vec, cvar_mat ) == -1 )
      return( E_RT_UNK ) ;

/*LOG COVARIANCE MATRIX*/
   fprintf( Log_fp, "\nCOVARIANCE MATRIX :" ) ;
   for( cnt = 1; cnt <= fit_ct; cnt++ )
      {
      fprintf( Log_fp, "\n    " ) ;
      for( cts = 1; cts <= fit_ct; cts++ )
         fprintf( Log_fp, "%-10.1e", cvar_mat[ cnt ][ cts ] ) ;
      }
   fprintf( Log_fp, "\n\n" ) ;



/*PLACE STANDARD DEVIATIONS IN GLOBAL TWO DIMENSIONAL ARRAY*/
   for( cnt = cts = 0, acyc_ct = 1;
         acyc_ct <= fit_ct; ((cts == ST_NOPAR + cnt) ? cnt++, cts = 0 : cts++) )
      if( Rc_stat[ cnt ][ cts ] && Lsf_stat[ cnt ][ cts ] )
         {
         Rc_sd[ cnt ][ cts ] = cvar_mat[ acyc_ct ][ acyc_ct ] ;
         acyc_ct++ ;
         }




/*FREE SPACE*/
   DFree2Dim( &v_mat, prm_no + 1 ) ;
   DFree1Dim( &w_vec ) ;
   DFree2Dim( &cvar_mat, prm_no + 1 ) ;



/*GENERATE NEW LINE SET BASED ON NEW PARAMETERS AND OLD DERIVATIVES*/
   if( GenLnSet( prm_no, prm ) == E_RT_UNK )
      return( E_RT_UNK ) ;



/*RETURN SUCCESS*/
   return( S_RT_FIN ) ;
   }














/*FORMATED PRINT OF CONSTANTS TO BE FIT OR VARIED -> INFORMATION LOGGED TO FILE*/
void LsfPrntPrm( long i_ct, long f_ct, long *fit_idx, long *str_idx, double *prm, double *prm_old, double *prm_std )
   {
   long cnt = i_ct, cnt1, cts ;



/*LOG GROUND STATE CONSTANTS*/
   if( cnt <= f_ct && str_idx[ fit_idx[ cnt ] ] < 0 )
      {

   /*GROUND STATE*/
      fprintf( Log_fp, "GROUND STATE  :\n" ) ;
      for( cts = 1; cnt <= f_ct && str_idx[ fit_idx[ cnt ] ] < 0; cnt++, cts++ )
         {

      /*LOG PARAMETER LABEL*/
         fprintf( Log_fp, "%s ", Rc_str[ -str_idx[ fit_idx[ cnt ] ] - 1 ] ) ;

      /*LOG VALUES OF PARAMETERS*/
         if( prm != NULL )
            {

         /*LOG ORIGINAL (OLD) PARAMETER*/
            if( -str_idx[ fit_idx[ cnt ] ] - 1 < DK || -str_idx[ fit_idx[ cnt ] ] - 1 > dJ )
               {
               if( cts % 3 )
                  fprintf( Log_fp, "= %-21.6f  ", prm_old[ fit_idx[ cnt ] ] ) ;
               else
                  fprintf( Log_fp, "= %.6f  ", prm_old[ fit_idx[ cnt ] ] ) ;
               }
            else
               {
               if( cts % 3 )
                  fprintf( Log_fp, "= %-21.4e  ", prm_old[ fit_idx[ cnt ] ] ) ;
               else
                  fprintf( Log_fp, "= %.4e  ", prm_old[ fit_idx[ cnt ] ] ) ;
               }

         /*AFTER EACH 3 COLUMN SET*/
            if( !(cts % 3) && cnt <= f_ct && str_idx[ fit_idx[ cnt ] ] < 0 )
               {

            /*LOG NEW FIT PARAMETERS*/
               fprintf( Log_fp, "\n" ) ;
               for( cnt1 = cnt - 2; cnt1 <= cnt; cnt1++ )
                  {
                  if( -str_idx[ fit_idx[ cnt1 ] ] - 1 < DK || -str_idx[ fit_idx[ cnt1 ] ] - 1 > dJ )
                     {
                     if( cnt1 != cnt )
                        fprintf( Log_fp, "     = %-21.6f  ", prm[ fit_idx[ cnt1 ] ] ) ;
                     else
                        fprintf( Log_fp, "     = %.6f  ", prm[ fit_idx[ cnt1 ] ] ) ;
                     }
                  else
                     {
                     if( cnt1 != cnt )
                        fprintf( Log_fp, "     = %-21.4e  ", prm[ fit_idx[ cnt1 ] ] ) ;
                     else
                        fprintf( Log_fp, "     = %.4e  ", prm[ fit_idx[ cnt1 ] ] ) ;
                     }
                  }

            /*LOG OLD - NEW FIT PARAMETERS*/
               fprintf( Log_fp, "\n" ) ;
               for( cnt1 = cnt - 2; cnt1 <= cnt; cnt1++ )
                  {
                  if( -str_idx[ fit_idx[ cnt1 ] ] - 1  < DK || -str_idx[ fit_idx[ cnt1 ] ] - 1 > dJ )
                     {
                     if( cnt1 != cnt )
                        fprintf( Log_fp, "     = %-21.6f  ", prm_old[ fit_idx[ cnt1 ] ] - prm[ fit_idx[ cnt1 ] ] ) ;
                     else
                        fprintf( Log_fp, "     = %.6f  ", prm_old[ fit_idx[ cnt1 ] ] - prm[ fit_idx[ cnt1 ] ] ) ;
                     }
                  else
                     {
                     if( cnt1 != cnt )
                        fprintf( Log_fp, "     = %-21.4e  ", prm_old[ fit_idx[ cnt1 ] ] - prm[ fit_idx[ cnt1 ] ] ) ;
                     else
                        fprintf( Log_fp, "     = %.4e  ", prm_old[ fit_idx[ cnt1 ] ] - prm[ fit_idx[ cnt1 ] ] ) ;
                     }
                  }

            /*LOG NEW STANDARD DEVIATIONS*/
               fprintf( Log_fp, "\n" ) ;
               for( cts = 0, cnt1 = cnt - 2; cnt1 <= cnt; cnt1++ )
                  {
                  if( -str_idx[ fit_idx[ cnt1 ] ] - 1 < DK || -str_idx[ fit_idx[ cnt1 ] ] - 1 > dJ )
                     {
                     if( cnt1 != cnt )
                        fprintf( Log_fp, "     = %-21.6f  ", prm_std[ fit_idx[ cnt1 ] ] ) ;
                     else
                        fprintf( Log_fp, "     = %.6f  ", prm_std[ fit_idx[ cnt1 ] ] ) ;
                     }
                  else
                     {
                     if( cnt1 != cnt )
                        fprintf( Log_fp, "     = %-21.4e  ", prm_std[ fit_idx[ cnt1 ] ] ) ;
                     else
                        fprintf( Log_fp, "     = %.4e  ", prm_std[ fit_idx[ cnt1 ] ] ) ;
                     }
                  }

               fprintf( Log_fp, "\n\n" ) ;
               }
            }
         }


   /*LOG VALUES OF PARAMETERS*/
      if( prm != NULL && --cts )
         {
         fprintf( Log_fp, "\n" ) ;
         for( cnt1 = cnt - cts; cnt1 < cnt; cnt1++ )
            {
            if( -str_idx[ fit_idx[ cnt1 ] ] - 1 < DK || -str_idx[ fit_idx[ cnt1 ] ] - 1 > dJ )
               fprintf( Log_fp, "     = %-21.6f  ", prm[ fit_idx[ cnt1 ] ] ) ;
            else
               fprintf( Log_fp, "     = %-21.4e  ", prm[ fit_idx[ cnt1 ] ] ) ;
            }
         fprintf( Log_fp, "\n" ) ;
         for( cnt1 = cnt - cts; cnt1 < cnt; cnt1++ )
            {
            if( -str_idx[ fit_idx[ cnt1 ] ] - 1 < DK || -str_idx[ fit_idx[ cnt1 ] ] - 1 > dJ )
               fprintf( Log_fp, "     = %-21.6f  ", prm_old[ fit_idx[ cnt1] ] - prm[ fit_idx[ cnt1 ] ] ) ;
            else
               fprintf( Log_fp, "     = %-21.4e  ", prm_old[ fit_idx[ cnt1] ] - prm[ fit_idx[ cnt1 ] ] ) ;
            }
         fprintf( Log_fp, "\n" ) ;
         for( cnt1 = cnt - cts; cnt1 < cnt; cnt1++ )
            {
            if( -str_idx[ fit_idx[ cnt1 ] ] - 1 < DK || -str_idx[ fit_idx[ cnt1 ] ] - 1 > dJ )
               fprintf( Log_fp, "     = %-21.6f  ", prm_std[ fit_idx[ cnt1] ] ) ;
            else
               fprintf( Log_fp, "     = %-21.4e  ", prm_std[ fit_idx[ cnt1] ] ) ;
            }

         fprintf( Log_fp, "\n\n" ) ;
         }

      else if( prm == NULL )
         fprintf( Log_fp, "\n\n" ) ;
      }






/*LOG EXCITED STATE CONSTANTS*/
   if( cnt <= f_ct && str_idx[ fit_idx[ cnt ] ] <= ST_NOPAR )
      {

   /*EXCITED STATE*/
      fprintf( Log_fp, "EXCITED STATE :\n" ) ;
      for( cts = 1; cnt <= f_ct && str_idx[ fit_idx[ cnt ] ] <= ST_NOPAR; cnt++, cts++ )
         {

      /*LOG PARAMETER LABEL*/
         fprintf( Log_fp, "%s ", Rc_str[ str_idx[ fit_idx[ cnt ] ] - 1 ] ) ;

      /*LOG VALUES OF PARAMETERS*/
         if( prm != NULL )
            {

         /*LOG ORIGINAL (OLD) PARAMETER*/
            if( str_idx[ fit_idx[ cnt ] ] - 1 < DK || str_idx[ fit_idx[ cnt ] ] - 1 > dJ )
               {
               if( cts % 3 )
                  fprintf( Log_fp, "= %-21.6f  ", prm_old[ fit_idx[ cnt ] ] ) ;
               else
                  fprintf( Log_fp, "= %.6f  ", prm_old[ fit_idx[ cnt ] ] ) ;
               }
            else
               {
               if( cts % 3 )
                  fprintf( Log_fp, "= %-21.4e  ", prm_old[ fit_idx[ cnt ] ] ) ;
               else
                  fprintf( Log_fp, "= %.4e  ", prm_old[ fit_idx[ cnt ] ] ) ;
               }

         /*AFTER EACH 3 COLUMN SET*/
            if( !(cts % 3) )
               {

            /*LOG NEW FIT PARAMETERS*/
               fprintf( Log_fp, "\n" ) ;
               for( cnt1 = cnt - 2; cnt1 <= cnt; cnt1++ )
                  {
                  if( str_idx[ fit_idx[ cnt1 ] ] - 1 < DK || str_idx[ fit_idx[ cnt1 ] ] - 1 > dJ )
                     {
                     if( cnt1 != cnt )
                        fprintf( Log_fp, "     = %-21.6f  ", prm[ fit_idx[ cnt1 ] ] ) ;
                     else
                        fprintf( Log_fp, "     = %.6f  ", prm[ fit_idx[ cnt1 ] ] ) ;
                     }
                  else
                     {
                     if( cnt1 != cnt )
                        fprintf( Log_fp, "     = %-21.4e  ", prm[ fit_idx[ cnt1 ] ] ) ;
                     else
                        fprintf( Log_fp, "     = %.4e  ", prm[ fit_idx[ cnt1 ] ] ) ;
                     }
                  }

            /*LOG OLD - NEW FIT PARAMETERS*/
               fprintf( Log_fp, "\n" ) ;
               for( cnt1 = cnt - 2; cnt1 <= cnt; cnt1++ )
                  {
                  if( str_idx[ fit_idx[ cnt1 ] ] - 1 < DK || str_idx[ fit_idx[ cnt1 ] ] - 1 > dJ )
                     {
                     if( cnt1 != cnt )
                        fprintf( Log_fp, "     = %-21.6f  ", prm_old[ fit_idx[ cnt1 ] ] - prm[ fit_idx[ cnt1 ] ] ) ;
                     else
                        fprintf( Log_fp, "     = %.6f  ", prm_old[ fit_idx[ cnt1 ] ] - prm[ fit_idx[ cnt1 ] ] ) ;
                     }
                  else
                     {
                     if( cnt1 != cnt )
                        fprintf( Log_fp, "     = %-21.4e  ", prm_old[ fit_idx[ cnt1 ] ] - prm[ fit_idx[ cnt1 ] ] ) ;
                     else
                        fprintf( Log_fp, "     = %.4e  ", prm_old[ fit_idx[ cnt1 ] ] - prm[ fit_idx[ cnt1 ] ] ) ;
                     }
                  }

            /*LOG NEW STANDARD DEVIATIONS*/
               fprintf( Log_fp, "\n" ) ;
               for( cts = 0, cnt1 = cnt - 2; cnt1 <= cnt; cnt1++ )
                  {
                  if( str_idx[ fit_idx[ cnt1 ] ] - 1 < DK || str_idx[ fit_idx[ cnt1 ] ] - 1 > dJ )
                     {
                     if( cnt1 != cnt )
                        fprintf( Log_fp, "     = %-21.6f  ", prm_std[ fit_idx[ cnt1 ] ] ) ;
                     else
                        fprintf( Log_fp, "     = %.6f  ", prm_std[ fit_idx[ cnt1 ] ] ) ;
                     }
                  else
                     {
                     if( cnt1 != cnt )
                        fprintf( Log_fp, "     = %-21.4e  ", prm_std[ fit_idx[ cnt1 ] ] ) ;
                     else
                        fprintf( Log_fp, "     = %.4e  ", prm_std[ fit_idx[ cnt1 ] ] ) ;
                     }
                  }

               fprintf( Log_fp, "\n\n" ) ;
               }
            }
         }

   /*LOG VALUES OF PARAMETERS*/
      if( prm != NULL && --cts )
         {
         fprintf( Log_fp, "\n" ) ;
         for( cnt1 = cnt - cts; cnt1 < cnt; cnt1++ )
            if( str_idx[ fit_idx[ cnt1 ] ] - 1 < DK || str_idx[ fit_idx[ cnt1 ] ] - 1 > dJ )
               fprintf( Log_fp, "     = %-21.6f  ", prm[ fit_idx[ cnt1 ] ] ) ;
            else
               fprintf( Log_fp, "     = %-21.4e  ", prm[ fit_idx[ cnt1 ] ] ) ;

         fprintf( Log_fp, "\n" ) ;
         for( cnt1 = cnt - cts; cnt1 < cnt; cnt1++ )
            if( str_idx[ fit_idx[ cnt1 ] ] - 1 < DK || str_idx[ fit_idx[ cnt1 ] ] - 1 > dJ )
               fprintf( Log_fp, "     = %-21.6f  ", prm_old[ fit_idx[ cnt1] ] - prm[ fit_idx[ cnt1 ] ] ) ;
            else
               fprintf( Log_fp, "     = %-21.4e  ", prm_old[ fit_idx[ cnt1] ] - prm[ fit_idx[ cnt1 ] ] ) ;

         fprintf( Log_fp, "\n" ) ;
         for( cnt1 = cnt - cts; cnt1 < cnt; cnt1++ )
            if( str_idx[ fit_idx[ cnt1 ] ] - 1 < DK || str_idx[ fit_idx[ cnt1 ] ] - 1 > dJ )
               fprintf( Log_fp, "     = %-21.6f  ", prm_std[ fit_idx[ cnt1 ] ] ) ;
            else
               fprintf( Log_fp, "     = %-21.4e  ", prm_std[ fit_idx[ cnt1 ] ] ) ;

         fprintf( Log_fp, "\n\n" ) ;
         }

      else if( prm == NULL )
         fprintf( Log_fp, "\n\n" ) ;
      }



/*LOG ORIGIN*/
   if( cnt <= f_ct )
      {
      fprintf( Log_fp, "%s ", Rc_str[ str_idx[ fit_idx[ cnt ] ] - 1 ] ) ;
      if( prm != NULL )
         {
         fprintf( Log_fp, "= %.6f", prm_old[ fit_idx[ cnt ] ] ) ;
         fprintf( Log_fp, "\n     = %.6f", prm[ fit_idx[ cnt ] ] ) ;
         fprintf( Log_fp, "\n     = %.6f", prm_old[ fit_idx[ cnt ] ] - prm[ fit_idx[ cnt ] ] ) ;
         fprintf( Log_fp, "\n     = %.6f", prm_std[ fit_idx[ cnt ] ] ) ;
         }
      fprintf( Log_fp, "\n\n" ) ;
      }
   }










/*
   if( (dvs_no = St_nodv[ GND ] + St_nodv[ EXE ]) != prm_no - 1 )
      {
      fprintf( Log_fp, "\nLSFTRS -> NOT ENOUGH DERIVATIVE INFORMATION !\n" ) ;
      return( E_RT_UNK ) ;
      }
       /NUMERICAL RECIPES LINEAR LEAST SQUARES ROUTINE USING GAUSS-JORDAN ELIMINATION/
         if( lfit( (double *)NULL, obln_vec, acp_nolvs, prm, prm_no, fit_idx, fit_ct, cvar_mat, &chi_sq, dvs_mat ) == -1 )
            return( E_RT_UNK ) ;

   printf( "ASSIGNED Rc[ %ld ][ %ld ] = %lf\n", cnt, cts, Rc[ cnt ][ cts ] ) ;
   printf( "Rc_stat[ %ld ][ %ld ] = %hd\n", cnt, cts, Rc_stat[ cnt ][ cts ] ) ;
   printf( "Rc[ %ld ][ %ld ] = %lf\n", cnt, cts, Rc[ cnt ][ cts ] ) ;
   printf( "Rc[ %ld ][ %ld ] = %lf\n", cnt, cts, Rc[ cnt ][ cts ] ) ;
*/
