/*************************************************************************
 *                                                                       *
 *  KTheme                                                               *
 *                                                                       *
 * This file is part of the KTheme-Package. For detail information about *
 * this program have a look at the README-File.                          *
 *                                                                       *
 * Copyright(c) 1998 Christian Poulter.                                  *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to cpoulter@ebs-net.com                                        *
 *                                                                       *
 *************************************************************************/

#include <qdir.h>
#include <qlistbox.h>


#include <kapp.h>
#include <kwm.h>
#include <ksimpleconfig.h>
#include <klocale.h>

#include "kthemesoundconfig.h"

static bool GUI;

KThemeSoundConfig::~KThemeSoundConfig (){
	if (GUI){
	}
}

KThemeSoundConfig::KThemeSoundConfig (QWidget * parent, const char *name, bool init):KConfigWidget (parent, name){
	if (init)
		GUI = FALSE;
	else
		GUI = TRUE;
	
	if (GUI){

		path_scheme=KApplication::kde_datadir()+"/ktheme/soundthemes";

		loadSettings();

		playbtn=new QPushButton(this);
		playbtn->resize(100,30);
		playbtn->setText(klocale->translate("Play"));

		stopbtn=new QPushButton(this);
		stopbtn->resize(100,30);
		stopbtn->setText(klocale->translate("Stop"));
	
		scheme_Listbox = new QListBox( this, "listBox" );
		scheme_Listbox->resize(200,200);
		scheme_Listbox->setAutoUpdate( FALSE );

		QDir d(path_scheme);
		d.setFilter( QDir::Dirs );
		d.setSorting( QDir::Name );
		d.setNameFilter("*");

		int citem=0;

		scheme_Listbox->clear();
		scheme_Listbox->insertItem( klocale->translate("No Sounds"));
		scheme_Listbox->insertItem( klocale->translate("Current scheme"));
		scheme_Listbox->setCurrentItem(1);
		for ( unsigned int i=0; i<d.count(); i++ ) {
			QString tmp=d[i];
			if ((tmp!=".")&&(tmp!="..")){
				scheme_Listbox->insertItem(tmp);
				if (tmp==oldscheme) citem=i;
			}
		}
		scheme_Listbox->setAutoUpdate(TRUE);

		scheme_Listbox->setCurrentItem(citem);

		preview=new KTabListBox (this,"Hello",6,2);
		preview->setGeometry(20,20,430,320);
		preview->clearTableFlags(Tbl_hScrollBar);
		preview->setTableFlags(Tbl_autoHScrollBar);
		preview->setTableFlags(Tbl_autoVScrollBar);
		preview->setSeparator('\n');
		preview->setColumn(0, klocale->translate("Action"), width()/2-20);
		preview->setColumn(1, klocale->translate("Sound"), width()/2-20);

		loadScheme(path_scheme+"/"+scheme_Listbox->text(citem)+"/"+scheme_Listbox->text(citem)+".kwmsoundrc");
		if (stEnable=="No") scheme_Listbox->setCurrentItem(0);

		connect( scheme_Listbox, SIGNAL(highlighted(int)),SLOT(selectScheme(int)));
		connect( playbtn, SIGNAL(clicked()),SLOT(play()));
		connect( stopbtn, SIGNAL(clicked()),SLOT(stop()));

		resize(450,430);
		setMinimumSize(size());
	}
}

void KThemeSoundConfig::resizeEvent(QResizeEvent *){
	preview->setGeometry(20,20,width()-40,220);	
	preview->setColumn(0, "Action", width()/2-20);
	preview->setColumn(1, "Sound", width()/2-20);
	playbtn->setGeometry(20,250,width()/2-40,20);
	stopbtn->setGeometry(width()/2+20,250,width()/2-40,20);
	scheme_Listbox->setGeometry(20,300,width()-40,height()-320);
}

void KThemeSoundConfig::play(){
	stop();
	QString tmp=preview->text((preview->currentItem()));
	tmp=tmp.right(tmp.length()-tmp.find(preview->separator(),0,false)-1);
	tmp=tmp.left(tmp.find(preview->separator(),0,false));

	if (scheme_Listbox->currentItem()==0){
		return;
	}else if (scheme_Listbox->currentItem()>1){
		tmp=path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+tmp;
	}
	audio.play((char*)tmp.data());
}

void KThemeSoundConfig::stop(){
	audio.stop();
}

void KThemeSoundConfig::selectScheme(int index){
	QApplication::setOverrideCursor( waitCursor );
	loadScheme(path_scheme+"/"+scheme_Listbox->text(index)+"/"+scheme_Listbox->text(index)+".kwmsoundrc");
	QApplication::restoreOverrideCursor();
}

void KThemeSoundConfig::loadSettings(){
	KConfigBase *config;
	config=	KApplication::getKApplication()->getConfig();
	config->setGroup("General");
	oldscheme=config->readEntry("LastSoundScheme");	
}

void KThemeSoundConfig::loadScheme(QString name){

	KConfigBase *config;
	
	int old=preview->currentItem();
	preview->clear();
	
	if (scheme_Listbox->currentItem()==0){
		stEnable="No";
		preview->repaint();
		return;
	}else if (scheme_Listbox->currentItem()==1){
		config=new KSimpleConfig(KApplication::localconfigdir() + "/kwmsoundrc");
	}else{
		config=new KSimpleConfig(name);
	}

	stEnable="Yes";

	config->setGroup("SoundConfiguration");

	stDesktop1=config->readEntry("Desktop1","");
	stDesktop2=config->readEntry("Desktop2","");
	stDesktop3=config->readEntry("Desktop3","");
	stDesktop4=config->readEntry("Desktop4","");
	stDesktop5=config->readEntry("Desktop5","");
	stDesktop6=config->readEntry("Desktop6","");
	stDesktop7=config->readEntry("Desktop7","");
	stDesktop8=config->readEntry("Desktop8","");
	stWindowActivate=config->readEntry("WindowActivate","");
	stWindowOpen=config->readEntry("WindowOpen","");
	stWindowClose=config->readEntry("WindowClose","");
	stStartup=config->readEntry("Startup","");
	stWindowShadeUp=config->readEntry("WindowShadeUp","");
	stWindowShadeDown=config->readEntry("WindowShadeDown","");
	stWindowIconify=config->readEntry("WindowIconify","");
	stWindowDeIconify=config->readEntry("WindowDeIconify","");
	stWindowMaximize=config->readEntry("WindowMaximize","");
	stWindowUnMaximize=config->readEntry("WindowUnMaximize","");
	stWindowSticky=config->readEntry("WindowSticky","");
	stWindowUnSticky=config->readEntry("WindowUnSticky","");
	stWindowTransNew=config->readEntry("WindowTransNew","");
	stWindowTransDelete=config->readEntry("WindowTransDelete","");
	stLogout=config->readEntry("Logout","");
	stLogoutMessage=config->readEntry("LogoutMessage","");
	stWindowMoveStart=config->readEntry("WindowMoveStart","");
	stWindowMoveEnd=config->readEntry("WindowMoveEnd","");
	stWindowResizeStart=config->readEntry("WindowResizeStart","");
	stWindowResizeEnd=config->readEntry("WindowResizeEnd","");

	preview->setAutoUpdate(FALSE);
	preview->insertItem("Desktop1\n"+stDesktop1);
	preview->insertItem("Desktop2\n"+stDesktop2);
	preview->insertItem("Desktop3\n"+stDesktop3);
	preview->insertItem("Desktop4\n"+stDesktop4);
	preview->insertItem("Desktop5\n"+stDesktop5);
	preview->insertItem("Desktop6\n"+stDesktop6);
	preview->insertItem("Desktop7\n"+stDesktop7);
	preview->insertItem("Desktop8\n"+stDesktop8);
	preview->insertItem("WindowActivate\n"+stWindowActivate);
	preview->insertItem("WindowOpen\n"+stWindowOpen);
	preview->insertItem("WindowClose\n"+stWindowClose);
	preview->insertItem("Startup\n"+stStartup);
	preview->insertItem("WindowShadeUp\n"+stWindowShadeUp);
	preview->insertItem("WindowShadeDown\n"+stWindowShadeDown);
	preview->insertItem("WindowIconify\n"+stWindowIconify);
	preview->insertItem("WindowDeIconify\n"+stWindowDeIconify);
	preview->insertItem("WindowMaximize\n"+stWindowMaximize);
	preview->insertItem("WindowUnMaximize\n"+stWindowUnMaximize);
	preview->insertItem("WindowSticky\n"+stWindowSticky);
	preview->insertItem("WindowUnSticky\n"+stWindowUnSticky);
	preview->insertItem("WindowTransNew\n"+stWindowTransNew);
	preview->insertItem("WindowTransDelete\n"+stWindowTransDelete);
	preview->insertItem("Logout\n"+stLogout);
	preview->insertItem("LogoutMessage\n"+stLogoutMessage);
	preview->insertItem("WindowMoveStart\n"+stWindowMoveStart);
	preview->insertItem("WindowMoveEnd\n"+stWindowMoveEnd);
	preview->insertItem("WindowResizeStart\n"+stWindowResizeStart);
	preview->insertItem("WindowResizeEnd\n"+stWindowResizeEnd);
	preview->setCurrentItem(old);
	preview->setAutoUpdate(TRUE);
	preview->repaint();
}

void KThemeSoundConfig::writeSettings(){

	KConfigBase *config;
	
	config=new KSimpleConfig(KApplication::localconfigdir() + "/kwmsoundrc");

	config->setGroup("GlobalConfiguration");
	config->writeEntry("EnableSounds", stEnable);

	if (scheme_Listbox->currentItem()>1){

		config->setGroup("SoundConfiguration");
	
		config->writeEntry("Desktop1",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stDesktop1);
		config->writeEntry("Desktop2",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stDesktop2);
		config->writeEntry("Desktop3",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stDesktop3);
		config->writeEntry("Desktop4",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stDesktop4);
		config->writeEntry("Desktop5",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stDesktop5);
		config->writeEntry("Desktop6",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stDesktop6);
		config->writeEntry("Desktop7",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stDesktop7);
		config->writeEntry("Desktop8",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stDesktop8);
		config->writeEntry("WindowActivate",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stWindowActivate);
		config->writeEntry("WindowOpen",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stWindowOpen);
		config->writeEntry("WindowClose",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stWindowClose);
		config->writeEntry("Startup",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stStartup);
		config->writeEntry("WindowShadeUp",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stWindowShadeUp);
		config->writeEntry("WindowShadeDown",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stWindowShadeDown);
		config->writeEntry("WindowIconify",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stWindowIconify);
		config->writeEntry("WindowDeIconify",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stWindowDeIconify);
		config->writeEntry("WindowMaximize",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stWindowMaximize);
		config->writeEntry("WindowUnMaximize",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stWindowUnMaximize);
		config->writeEntry("WindowSticky",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stWindowSticky);
		config->writeEntry("WindowUnSticky",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stWindowUnSticky);
		config->writeEntry("WindowTransNew",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stWindowTransNew);
		config->writeEntry("WindowTransDelete",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stWindowTransDelete);
		config->writeEntry("Logout",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stLogout);
		config->writeEntry("LogoutMessage",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stLogoutMessage);
		config->writeEntry("WindowMoveStart",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stWindowMoveStart);
		config->writeEntry("WindowMoveEnd",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stWindowMoveEnd);
		config->writeEntry("WindowResizeStart",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stWindowResizeStart);	
		config->writeEntry("WindowResizeEnd",path_scheme+"/"+scheme_Listbox->text(scheme_Listbox->currentItem())+"/"+stWindowResizeEnd);
	}

	config->sync();

	config=	KApplication::getKApplication()->getConfig();
	config->setGroup("General");
	config->writeEntry("LastSoundScheme",oldscheme);	
	config->sync();
}



void KThemeSoundConfig::applySettings(){

	if (oldscheme!=scheme_Listbox->text(scheme_Listbox->currentItem())){
		oldscheme=scheme_Listbox->text(scheme_Listbox->currentItem());
		writeSettings();
		KWM::sendKWMCommand("syssnd_restart");
	}

}

