/***************************************************************************
                          ktar.cpp  -  description
                             -------------------
    begin                : Thu Oct 14 1999
    copyright            : (C) 1999 by Rene Mrten, Christian Fricke
                           und Torsten Enkelmann
    email                : @-Mail to: delta_x@LinuxCoding.DE
                                      cfricke@LinuxCoding.DE
                                      Torsten@LinuxCoding.DE
****************************************************************************/

#include "ktar.h"
#include "optionen.h"
#include <qapplication.h>

KTar::KTar(const char * tempfile, const char *archivename,QWidget *parent, const char *name) : QDialog(parent,name,true)
{
//*****************************************************************************************
	// Optik !!
	temp = tempfile;
	arc = archivename;
	ende = false;
	resize(300,120);
	setMinimumSize(300,120);
	setMaximumSize(300,120);
	QLabel *l;
	l = new QLabel("Info:",this);
	l->setGeometry(10,30,50,20);
	dateiname = new QLabel(i18n("File :"),this);
	dateiname->setGeometry(60,30,230,20);
	QString s;
	Packer = optionen::askPacker();
	s.sprintf(QString("KTar ") + i18n("compress with ") + Packer);
 	setCaption(s);
	p1 = new myProgress(0,100,0,myProgress::Horizontal,this);
	p1->setGeometry(10,55,280,20);

	startTimer(100);			
}

KTar::~KTar(){
	delete dateiname;
}


void	KTar::timerEvent(QTimerEvent *e)
{
	killTimers();
	doIt(temp,arc);
}
void KTar::doIt(const char *tempfile, const char *archivename)
{
		QFile f(tempfile);		// tempfile ffnen
		int files = 0;				// filecounter = 0
		int percent=0;
		QString s;
		
		if(f.open(IO_ReadOnly))	// ist tempfile da ? sollte !!
		{
			QTextStream t( &f );        // use a text stream
			s = t.readLine();
			// ins Verzeichnis <s> wechseln
			QDir::setCurrent(s);
			// jetzt Anzahl files einlesen
			while ( !t.eof() )       // until end of file...
      {
      	files ++;
				s = t.readLine();
      }
			f.close();
		//FUX
		p1->setValueRange(0,files);
		percent = 0;
		kapp->processEvents();
		}
		else
		{
			//tempfile wech !!
			close();
			reject();
		}
	
		f.open(IO_ReadOnly);
		QTextStream t( &f );        // use a text stream
//************************************************************************************	
		
		s = t.readLine();
		s = t.readLine();
		dateiname->setText(s);
		nextFile = false;			// muss warten, solange bis TAR Ergebnis zurckgibt (false or true, togal!)
		KShellProcess proc;
		proc << "tar";
		proc << "cvf";                        // neues Archiv erstellen !
		proc << QString(archivename)+".tar";	// Archivename
		proc << s;														// Dateiname
		QApplication::connect(&proc, SIGNAL(processExited(KProcess *)),this, SLOT(slotExamine()));
		QApplication::connect(&proc, SIGNAL(receivedStdout(KProcess *, char *, int)), this, SLOT(receivedStdout(KProcess *, char *, int)));
		QApplication::connect(&proc, SIGNAL(receivedStderr(KProcess *, char *, int)), this, SLOT(receivedStderr(KProcess *, char *, int)));
		proc.start(KProcess::Block,KProcess::All);
		p1->setValue(percent++);
		
		
		while(!nextFile)
			kapp->processEvents();	// solange in Schleife bleiben, wie nextFile = false

		// ersten Filenamen holen
		s = t.readLine();
		dateiname->setText(s);				


	// hier jetzt 2tes file packen !
	while(!t.eof())
	{
			s = t.readLine();
			p1->setValue(percent++);
			kapp->processEvents();
			QString ss=s;
			if(ss.length() >30)
			{
				ss = ss.left(15) + "...." + ss.right(15);
			}
			dateiname->setText(ss);
			KShellProcess proc;
			proc << "tar";
			proc << "rvf";
			proc << QString(archivename)+".tar";	// Archivename
			proc << s;						// Dateiname
			
			
			nextFile = false;					// das er nicht gleich noch weiter macht
			QApplication::connect(&proc, SIGNAL(processExited(KProcess *)),this, SLOT(slotExamine()));
			QApplication::connect(&proc, SIGNAL(receivedStdout(KProcess *, char *, int)), this, SLOT(receivedStdout(KProcess *, char *, int)));
			QApplication::connect(&proc, SIGNAL(receivedStderr(KProcess *, char *, int)), this, SLOT(receivedStderr(KProcess *, char *, int)));
			proc.start(KProcess::Block,KProcess::All);
			while(!nextFile)
				kapp->processEvents();	// solange in Schleife bleiben, wie nextFile = false
			if(ende == true)	// ende wird nur TRUE, wenn Fenster whrend des Packens geschlosssen wird
			{
				f.close();
				return;
			}
	}
	f.close();
	{
		KShellProcess proc;
		dateiname->setText(QString(i18n("Compressing Destination With ")) + Packer);
		kapp->processEvents();
		proc << Packer;
		proc << QString(archivename)+".tar";	// Archivename
		QApplication::connect(&proc, SIGNAL(processExited(KProcess *)),this, SLOT(slotExamine()));
		QApplication::connect(&proc, SIGNAL(receivedStdout(KProcess *, char *, int)), this, SLOT(receivedStdout(KProcess *, char *, int)));
		QApplication::connect(&proc, SIGNAL(receivedStderr(KProcess *, char *, int)), this, SLOT(receivedStderr(KProcess *, char *, int)));
		proc.start(KProcess::Block,KProcess::All);
		ende = true;
		close();
	}
}


void KTar::slotExamine()
{
//	QMessageBox::critical ( (QWidget *)this, "KTar", "prog zu Ende", 0, 0 );
	nextFile = true;
}
void KTar::receivedStdout(KProcess *p, char *buffer, int buflen)
{
	ready = true;
}
void KTar::receivedStderr(KProcess *p, char *buffer, int buflen)
{
	QString s = buffer;
	s = s.left(buflen);
	QMessageBox::critical ( (QWidget *)this, "KTar", s, 0, 0 );
	killTimers();
	ende = true;
	nextFile = true;
	close();
}
void KTar::closeEvent ( QCloseEvent *e)
{
  if(!ende)
  {
		int i = QMessageBox::information ( this, i18n("Cancel ?"), i18n("Break This Process ?"), QMessageBox::Yes, QMessageBox::No);
		if(i == QMessageBox::Yes)
		{
			ende = true;
			e->accept();
		}
	}
	else
		e->accept();
}
