/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _TOPLEVEL_H_
#define _TOPLEVEL_H_ 


#include "criterion.h"
#include <ktmainwindow.h>


class QGroupBox;
class QLineEdit;
class QPushButton;
class QListBox;
class QCheckBox;
class KButtonBox;
class QLabel;
class QBoxLayout;
class KProcess;


class TopLevel : public KTMainWindow
{
    Q_OBJECT

public:
    TopLevel();
    ~TopLevel();

protected slots:
    void slotSearch();
    void slotCancel();
    void slotMore();
    void slotLess();
    void childExited();
    void receivedOutput(KProcess *proc, char *buffer, int buflen);
    
private:
    void updateLayout();
    void processOutput();
    void finish();
    
    QLabel *dirlabel;
    QLineEdit *diredit;
    QCheckBox *subdirsbox;
    QCheckBox *mountedbox;
    QGroupBox *groupbox;
    QList<Criterion> criteria;
    //    KButtonBox *buttonbox;
    QPushButton *searchbutton, *cancelbutton;
    QPushButton *morebutton, *lessbutton;
    QLabel *foundlabel;
    QListBox *resultbox;
    QBoxLayout *grouplayout;
    KProcess *childproc;
    QString buf;
};
 
#endif 


// Local Variables:
// c-basic-offset: 4
// End:





















