/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#include <qregexp.h>
#include <stdio.h>
#include "misc.h"


QString removeHTML(const QString &str)
{
    QString res = str;
    int pos;
    while ( (pos = res.find('<')) != -1)
	{
	    int pos2 = res.find('>', pos);
	    if (pos2 == -1)
		pos2 = res.length();
	    res.remove(pos, pos2-pos+1);
	}
    return res;
}


// This function is taken from khtml, distributed under the LGPL
QString encodeString( const QString &e )
{
        static char *safe = "$-._!*(),"; /* RFC 1738 */
        unsigned pos = 0;
        QString encoded;
        char buffer[5];
 
        while ( pos < e.length() )
        {
                unsigned char c = (unsigned char) e[pos];
 
                if ( (( c >= 'A') && ( c <= 'Z')) ||
                     (( c >= 'a') && ( c <= 'z')) ||
                     (( c >= '0') && ( c <= '9')) ||
                     (strchr(safe, c))
                   )
                {
                        encoded += c;
                }
                else if ( c == ' ' )
                {
                        encoded += '+';
                }
                else if ( c == '\n' )
                {
                        encoded += "%0D%0A";
                }
                else if ( c != '\r' )
                {
                        sprintf( buffer, "%%%02X", (int)c );
                        encoded += buffer;
                }
                pos++;
        }
 
        return encoded;
}


// Local Variables:
// c-basic-offset: 4
// End:
