/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _SITEDEF_H_
#define _SITEDEF_H_


#include <qdict.h>


struct InputTag;

class SiteDefinition
{
public:
    SiteDefinition() { inputs.setAutoDelete(true); }
    QString makeQueryUrl(QString query);

    static SiteDefinition *definitionForName(QString name)
	{ return map[name]; }
    static QStrList names();
    static void readSiteDefinitions();
    
    QString description;
    QString action;
    QString icon;
    QList<InputTag> inputs;
    QString resultListStart;
    QString resultListEnd;
    QString resultItemStart;
    QString resultItemEnd;
    QString dateStart;
    QString dateEnd;
    QString subjectStart;
    QString subjectEnd;
    QString forumStart;
    QString forumEnd;
    QString authorStart;
    QString authorEnd;

private:
    static QDict<SiteDefinition> map;
};

#endif


// Local Variables:
// c-basic-offset: 4
// End:
