/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _SITEJOB_H_
#define _SITEJOB_H_


#include <kio_job.h>

class SiteDefinition;


class SiteJob : public KIOJob
{
    Q_OBJECT

public:
    SiteJob(SiteDefinition *site);
    void query(QString searchtext);

signals:
    void foundItem(QString date, QString sujbect, QString url,
		   QString forum, QString author);
    
protected slots:
    void gotData(int, const char *data, int len);
	
private:
    enum { Begin, ResultList, ResultItem, End } state;
    SiteDefinition *m_site;
    QString m_buf;
    void parseItem(QString item);
    void feedtest(QString filename);
};

 
#endif 


// Local Variables:
// c-basic-offset: 4
// End:





















