/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#include <qlineedit.h>
#include <qpushbutton.h>
#include <qmultilinedit.h>
#include <qlayout.h>
#include <kbuttonbox.h>
#include <kapp.h>
#include <kprocess.h>
#include "toplevel.h"
#include <iostream.h>



TopLevel::TopLevel()
{
    setCaption(i18n("Search NIC database"));

    QBoxLayout *layout = new QVBoxLayout(this, 10, 4);

    QGridLayout *grid = new QGridLayout(3, 4, 4);
    layout->addLayout(grid, 0);
    grid->setColStretch(0, 0);
    grid->setColStretch(1, 10);
    grid->setColStretch(2, 0);
    grid->addColSpacing(2, 10);
    grid->addRowSpacing(1, 15);
    grid->setRowStretch(1, 0);

    QLabel *wordslabel = new QLabel(i18n("What:"), this);
    wordslabel->setMinimumSize(wordslabel->sizeHint());
    grid->addWidget(wordslabel, 0, 0);

    wordsedit = new QLineEdit(this);
    wordsedit->setFocus();
    wordsedit->setFixedHeight(wordsedit->sizeHint().height());
    grid->addWidget(wordsedit, 0, 1);

    KButtonBox *buttonbox = new KButtonBox(this, KButtonBox::VERTICAL);
    searchbutton = buttonbox->addButton(i18n("&Search"));
    searchbutton->setDefault(true);
    connect( searchbutton, SIGNAL(clicked()), SLOT(slotSearch()) );
    cancelbutton = buttonbox->addButton(i18n("Cancel"));
    connect( cancelbutton, SIGNAL(clicked()), SLOT(slotCancel()) );
    cancelbutton->setEnabled(false);
    buttonbox->layout();
    grid->addMultiCellWidget(buttonbox, 0, 2, 3, 3);

    layout->addSpacing(15);
    
    resultbox = new QMultiLineEdit(this);
    resultbox->setReadOnly(true);
    QFontMetrics fm(fontMetrics());
    resultbox->setMinimumSize(100, fm.lineSpacing()*10);
    layout->addWidget(resultbox, 10);

    layout->activate();
    childproc = 0;
}


TopLevel::~TopLevel()
{
    if (childproc)
      delete childproc;
}


void TopLevel::slotSearch()
{
    searchbutton->setEnabled(false);
    cancelbutton->setEnabled(true);
    resultbox->clear();

    QString cmd = "whois ";
    cmd += wordsedit->text();
    childproc = new KShellProcess();
    *childproc << cmd;

    connect( childproc, SIGNAL(processExited(KProcess *)),
	     SLOT(childExited()) );
    connect( childproc, SIGNAL(receivedStdout(KProcess *, char *, int)),
	     SLOT(receivedOutput(KProcess *, char *, int)) );
    connect( childproc, SIGNAL(receivedStderr(KProcess *, char *, int)),
	     SLOT(receivedOutput(KProcess *, char *, int)) );
    childproc->start(KProcess::NotifyOnExit,
		     KProcess::Communication(KProcess::Stdout | KProcess::Stderr));
}


void TopLevel::finish()
{
    searchbutton->setEnabled(true);
    cancelbutton->setEnabled(false);
    if (childproc)
      delete childproc;
    childproc = 0;
}


void TopLevel::slotCancel()
{
    finish();
}


void TopLevel::childExited()
{
    finish();
}


void TopLevel::receivedOutput(KProcess *proc, char *buffer, int buflen)
{
    resultbox->append( QString(buffer, buflen+1) );
}



// Local Variables:
// c-basic-offset: 4
// End:










