// MailValidator: Control behavior of QLineEdit requesting e-mail address

#include "MailValidator.moc"
#include <ctype.h>
#include <qstring.h>

MailValidator::MailValidator(QLineEdit *parent, const char * name=0):QValidator(parent,name)
{
}
MailValidator::~MailValidator()
{
}
QValidator::State MailValidator::validate(QString &input, int &pos)
{
	for(unsigned int i=0;i<strlen(input);i++)
		if(!isalnum(input[i]) && input[i]!='@' && input[i]!='.' && input[i]!='_' && input[i]!='+' && input[i]!='-')
			return QValidator::Invalid;
	if(strchr(input,'@')!=strrchr(input,'@'))
		return QValidator::Invalid;
	if(input[strlen(input)-1]=='@')
		return QValidator::Acceptable;
	return QValidator::Valid;
}
void MailValidator::fixup(QString &input)
{
	// Not yet implemented...
}
