#ifndef FTPACCESS_H
#define FTPACCESS_H

// SETSTR: Copy string SOURCE to DEST; free dest first if neccessary.
#define SETSTR(dest,source) if(dest!=0) free(dest); if(source==0) dest=0; else dest=strdup(source)

#include <stream.h>
#include <iostream.h>
#include <qstrlist.h>
#include <stdlib.h>

class ftpaccess;
class ftpclass;
class ftplimit;
class ftpmessage;
class ftpupload;

#define	ANONYMOUS	1
#define	GUEST		2
#define REAL		4
#define ANONYMOUS_OUT	8
#define	GUEST_OUT	16
#define REAL_OUT	32

// Passwd-Check
#define NONE		0x0000
#define TRIVIAL		0x0001
#define RFC822		0x0002

#define WARN		0x0000
#define ENFORCE		0x0010

class ftpaccess {
	friend	ostream &operator << (ostream &os, ftpaccess *f);
public:
			ftpaccess(char const * const filename=0);
			~ftpaccess();	
	bool		read(char const * const filename="/etc/ftpaccess");
	bool		write(char const * const filename="/etc/ftpaccess");
	void		addClass(char const * const cmd);
	void		addClass(ftpclass *c);
	void		removeClass(char const * const name);
	ftpclass *	getNextClass(ftpclass *previous=0);
	ftpclass *	seekClass(char const * const name);
	QStrList *	getNoRetrieves() { return noretrieves; };
	void		setLoginFails(unsigned int n) { loginfails=n; };
	unsigned int	getLoginFails() const { return loginfails; };
	void		setPrivate(bool p) { priv=p; };
	bool		getPrivate() const { return priv; };
	void		setBanner(char * b) { banner=b; };
	char *		getBanner() const { return banner; };
	void		setHostname(char * h) { hostname=h; };
	char *		getHostname() { return hostname; };
	void		setAdminMail(char * m) { adminmail=m; };
	char *		getAdminMail() const { return adminmail; };
	int		getNumMessages() const { return numMessages; };
	int		getNumReadmes() const { return numReadmes; };
	bool		getMsgShowEverytime() const { return msgShowEverytime; };
	void		setMsgShowEverytime(bool s) { msgShowEverytime=s; };
	bool		getRdmShowEverytime() const { return rdmShowEverytime; };
	void		setRdmShowEverytime(bool s) { rdmShowEverytime=s; };
	ftpmessage *	getFirstMessage() const;
	ftpmessage *	getNextMessage(ftpmessage *m) const;
	ftpmessage *	getMessage(unsigned int const num) const;
	void		addMessage(ftpmessage *m);
	ftpmessage *	getFirstReadme() const;
	ftpmessage *	getNextReadme(ftpmessage *r) const;
	ftpmessage *	getReadme(unsigned int const num) const;
	void		addReadme(ftpmessage *r);
	void		deleteMessage(ftpmessage *m);
	void		deleteMessage(int num);
	void		deleteReadme(ftpmessage *r);
	void		deleteReadme(int num);
	unsigned short	getChmod() const { return chmd; };
	unsigned short	getDelete() const { return delet; };
	unsigned short	getOverwrite() const { return overwrite; };
	unsigned short	getRename() const { return rename; };
	unsigned short	getUmask() const { return umsk; };
	unsigned short	getPwCheck() const { return passwd_check; };
	void		setChmod(unsigned short c) { chmd=c; };
	void		setDelete(unsigned short d) { delet=d; };
	void		setOverwrite(unsigned short o) { overwrite=o; };
	void		setRename(unsigned short r) { rename=r; };
	void		setUmask(unsigned short u) { umsk=u; };
	void		setPwCheck(unsigned short p) { passwd_check=p; };
	unsigned short	getLogCommands() { return logCommands; };
	unsigned short	getLogTransfers() { return logTransfers; };
	unsigned short	getLogSecurity() { return logSecurity; };
	bool		getLogSyslog() { return logSyslog; };
	void		setLogCommands(unsigned short l) { logCommands=l; };
	void		setLogTransfers(unsigned short l) { logTransfers=l; };
	void		setLogSecurity(unsigned short l) { logSecurity=l; };
	void		setLogSyslog(bool l) { logSyslog=l; };
	char *		getAnonRoot() { return anonRoot; };
	char *		getGuestRoot() { return guestRoot; };
	char *		getPasswd() { return passwd; };
	char *		getShadow() { return shadow; };
	void		setAnonRoot(char *a);
	void		setGuestRoot(char *g);
	void		setPasswd(char *p);
	void		setShadow(char *s);
	unsigned short	getUlDlRatio() const { return ulDlRatio; };
	unsigned short	getUlDlRatioWho() const { return ulDlRatioWho; };
	long		getLimitTime() const { return limitTime; };
	unsigned short	getLimitTimeWho() const { return limitTimeWho; };
	long		getLimitUpload() const { return limitUpload; };
	unsigned short	getLimitUploadWho() const { return limitUploadWho; };
	long		getLimitDownload() const { return limitDownload; };
	unsigned short	getLimitDownloadWho() const { return limitDownloadWho; };
	void		setUlDlRatio(unsigned short u) { ulDlRatio=u; };
	void		setUlDlRatioWho(unsigned short u) { ulDlRatioWho=u; };
	void		setLimitTime(long t) { limitTime=t; };
	void		setLimitTimeWho(unsigned short t) { limitTimeWho=t; };
	void		setLimitUpload(long l) { limitUpload=l; };
	void		setLimitUploadWho(unsigned short l) { limitUploadWho=l; };
	void		setLimitDownload(long l) { limitDownload=l; };
	void		setLimitDownloadWho(unsigned short l) { limitDownloadWho=l; };	
	QStrList *	getDlFree() const { return dlFree; };
	QStrList *	getDlFreeDir() const { return dlFreeDir; };
	bool		getMailAdmin() const { return mailAdmin; };
	char *		getMailFrom() const { return mailFrom; };
	char *		getMailServer() const { return mailServer; };
	QStrList *	getMailRecipients() const { return mailRecipients; };
	void		setMailAdmin(bool s) { mailAdmin=s; };
	void		setMailFrom(char *s) { SETSTR(mailFrom,s); };
	void		setMailServer(char *s) { SETSTR(mailServer,s); };
	ftpupload *	getFirstUpload() const;
	ftpupload *	getNextUpload(ftpupload *last) const;
	ftpupload *	getUploadNo(int num) const;
	int		getNumUploads() const;
	void		deleteUpload(int num);
	void		deleteUpload(ftpupload *u);
	void		addUpload(ftpupload *u);
private:
	void		cleanup();
// Directories
	char *		anonRoot;
	char *		guestRoot;
	char *		passwd;
	char *		shadow;
// Classes
	unsigned int	numclasses;
	ftpclass **	classes;
// Security
	QStrList *	noretrieves;
	unsigned int	loginfails;
	bool		priv;
	unsigned short	chmd;
	unsigned short	delet;
	unsigned short	overwrite;
	unsigned short	rename;
	unsigned short	umsk;
	unsigned short	passwd_check;
	QStrList *	deny_email;
// Messages
	char *		banner;
	char *		hostname;
	char *		adminmail;
	ftpmessage **	messages;
	ftpmessage **	readmes;
	unsigned int	numMessages;
	unsigned int	numReadmes;
	bool		msgShowEverytime;
	bool		rdmShowEverytime;
// Logging
	unsigned short	logCommands;
	unsigned short	logTransfers;
	unsigned short	logSecurity;
	bool		logSyslog;
	bool		mailAdmin;
	char *		mailFrom;
	char *		mailServer;
	QStrList *	mailRecipients;
// Ratios
	unsigned short	ulDlRatio;
	unsigned short	ulDlRatioWho;
	long		limitTime;
	unsigned short	limitTimeWho;
	long		limitUpload;
	unsigned short	limitUploadWho;
	long		limitDownload;
	unsigned short	limitDownloadWho;
	QStrList *	dlFree;
	QStrList *	dlFreeDir;
// Uploads
	int		numUploads;
	ftpupload **	uploads;
};

class ftpclass {
public:
			ftpclass(char const * const cmd=0);
			~ftpclass();
	void		setAnon(bool anon);
	void		setGuest(bool guest);
	void		setReal(bool real);
	void		setName(char const * const newname);
	void		setAddrs(char const * const newaddrs);
	void		setAutogroup(char const * const group);
	void		addLimit(char const * const l);
	void		addLimit(ftplimit *l);
	void		deleteLimit(ftplimit const * const l);
	ftplimit *	getNextLimit(ftplimit const * const prev) const;
	bool const	isAnon() const;
	bool const	isGuest() const;
	bool const	isReal() const;
	char const * const	getName() const;
	char const * const	getAddrs() const;
	char const * const	getAutogroup() const;
private:
	char *		name;
	int		users;
	char *		addrs;
	char *		autogroup;
	ftplimit *	first;
};

#define ANY	1
#define MO	2
#define TU	4
#define WE	8
#define TH	16
#define FR	32
#define SA	64
#define SU	128
class ftplimit {
	friend ftpclass::deleteLimit(ftplimit const * const fl);
public:
	ftplimit(char const * const limit=0);
	ftplimit(int const num, char const * const t, char const * const msg);
	~ftplimit();
	void	setAny(bool any);
	void	setMo(bool mo);
	void	setTu(bool tu);
	void	setWe(bool we);
	void	setTh(bool th);
	void	setFr(bool fr);
	void	setSa(bool sa);
	void	setSu(bool su);
	void	setHours(char const * const h);
	void	setMsgfile(char const * const f);
	void	setNum(int const num)	{ numUsers=num; }
	void	addLimit(ftplimit *n);
	char *	getId() const;
	bool	isAny() const		{ return (weekdays&ANY)!=0; };
	bool	isMo() const		{ return (weekdays&MO)!=0; };
	bool	isTu() const		{ return (weekdays&TU)!=0; };
	bool	isWe() const		{ return (weekdays&WE)!=0; };
	bool	isTh() const		{ return (weekdays&TH)!=0; };
	bool	isFr() const		{ return (weekdays&FR)!=0; };
	bool	isSa() const		{ return (weekdays&SA)!=0; };
	bool	isSu() const		{ return (weekdays&SU)!=0; };
	char *	getHours() const	{ return hours; };
	char *	getMsgfile() const	{ return msgfile; };
	int	getNum() const		{ return numUsers; };
	ftplimit *	getNext() const { return next; };
private:
	void		setNextLimit(ftplimit *);
	unsigned short	weekdays;
	int		numUsers;
	char *		msgfile;
	char *		hours;
	ftplimit *	next;
};

class ftpmessage {
	friend ostream &operator << (ostream &os, ftpmessage *m);
public:
	ftpmessage(bool Readme=false,bool Login=true,char *p=0,char *d=0,char *c=0);
	~ftpmessage();
	void	setPath(char * p) { path=p; };
	char *	getPath() const { return path; };
	char *	getId() const;
	void	setReadme(bool r) { isReadme=r; };
private:
	bool		isReadme;
	bool		atLogin;
	char *		path;
	char *		dir;
	char *		cls;
};


class ftpupload {
	friend ostream &operator << (ostream &os, ftpupload *u);
public:
		ftpupload();
		~ftpupload();
	void	setRootDir(char const * const r) { SETSTR(rootDir,r); };
	void	setDirGlob(char const * const g) { SETSTR(dirGlob,g); };
	void	setAllow(bool const a) { allow=a; };
	void	setOwner(char const * const o) { SETSTR(owner,o); };
	void	setGroup(char const * const g) { SETSTR(group,g); };
	void	setMode(unsigned short const m) { mode=m; };
	void	setPermitDirs(bool const p) { permitDirs=p; };
	void	setDMode(unsigned short const m) { dMode=m; };
	char *	getRootDir() const { return rootDir; };
	char *	getDirGlob() const { return dirGlob; };
	bool	getAllow() const { return allow; };
	char *	getOwner() const { return owner; };
	char *	getGroup() const { return group; };
	unsigned short	getMode() const { return mode; };
	bool	getPermitDirs() const { return permitDirs; };
	unsigned short	getDMode() const { return dMode; };
	char const * const	getId() const;
private:
	char *		rootDir;
	char *		dirGlob;
	bool		allow;
	char *		owner;
	char *		group;
	unsigned short	mode;
	bool		permitDirs;
	unsigned short	dMode;
};

ostream &operator << (ostream &os, ftpaccess *f);
ostream &operator << (ostream &os, ftpclass *c);
ostream &operator << (ostream &os, ftplimit *f);
ostream &operator << (ostream &os, ftpmessage *m);
ostream &operator << (ostream &os, ftpupload *u);

#endif
