#include <ctype.h>	// for strcasestr (tolower)
#include <string.h>	// for strcasestr (strstr)
#include <stdlib.h>	// for strcasestr (free)
#ifndef HAVE_STRCASESTR
char *strcasestr(const char *haystack, const char *needle)
{
	char *h=strdup(haystack);
	char *n=strdup(needle);
	unsigned int r=0;
	bool returnNULL=true;
	for(unsigned int i=0; i<strlen(h); i++)
		h[i]=tolower(h[i]);
	for(unsigned int i=0; i<strlen(n); i++)
		n[i]=tolower(n[i]);
	if(strstr(h,n)) {
		returnNULL=false;
		r=strstr(h,n)-h;
	}
	free(h);
	free(n);
	if(returnNULL)
		return 0;
	return (char *)haystack+r;
}
#endif
