#ifndef __ACCDLG_H
#define __ACCDLG_H

#include <stdio.h>
#include <ctype.h>

#include <kapp.h>
#include <klocale.h>

#include <qbttngrp.h>
#include <qchkbox.h>
#include <qcombo.h>
#include <qframe.h>
#include <qgrpbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlined.h>
#include <qlistbox.h>
#include <qmsgbox.h>
#include <qpushbt.h>
#include <qradiobt.h>
#include <qtabdlg.h>
#include <qtooltip.h>

#include "logo.h"
#include "mytypes.h"
#include "kISDNdata.h"

#define NEW   1
#define EDIT  2


class DevicesWidget : public QWidget
{
  Q_OBJECT
  
  QCheckBox    *Bundlecheck;
  QComboBox    *Encapsbox, *Layer2box, *Layer3box;
  QGroupBox    *GBoxM;
  QLabel       *Provlabel, *Remotelabel, *Listlabel, *Diallabel, *HupTimelabel, *Sec1label;
  QLabel       *pmPhone, *Encapslabel, *Layer2label, *Layer3label, *Delaylabel, *Sec2label;
  QListBox     *Phonelist;
  QPushButton  *Addbutton, *Removebutton;
    
  void  setBundleState();  
  void  Backup();
  void  Restore();
  
  public:

  QLineEdit    *Provider, *Attempts, *HupTime, *Remote, *Delay;
  
  DevicesWidget(QWidget *parent = 0, const char *name = 0); 

  private slots:
  
  void slotAddRemote();
  void slotRemoveRemote();
  void slotEncapsChanged(int);
  void slotLayer2Changed(int);
  void slotLayer3Changed(int);
  void slotBundleClicked();
};


class IPWidget : public QWidget
{
  Q_OBJECT
  
  QButtonGroup  *IPGroup;
  QFrame        *Etched;
  QGroupBox     *GBox, *IPGBox;
  QLabel        *pmMail, *IPloclabel, *IPremlabel, *Masklabel;
  QRadioButton  *DynButton, *StatButton;
  QVBoxLayout   *IPVBox;
    
  void setIPStatic(bool);
 
  public:
  
  QLineEdit     *IPloc, *IPrem, *Mask;
  
  IPWidget(QWidget *parent = 0, const char *name = 0);
  
  private slots:
  
  void slotRButtonClicked(int);
};


class DNSWidget : public QWidget
{
  Q_OBJECT
  
  QButtonGroup  *IPGroup;
  QGroupBox     *GBox;
  QLabel        *Domainlabel, *DNSlabel, *DNSListlabel;
  QLineEdit     *DNS;
  QListBox      *DNSList;
  QPushButton   *AddButton, *RemButton;
  
  void messageBadIP();
  
  public:

  QLineEdit  *Domain;
   
  DNSWidget(QWidget *parent = 0, const char *name = 0);
  
  private slots:
  
  void slotAddDNS();
  void slotRemoveDNS();
};


class AuthWidget : public QWidget
{
  Q_OBJECT
  
  QButtonGroup  *AuthGroup;
  QFrame        *Etched;
  QGroupBox     *GBox;
  QLabel        *Userlabel, *Passwordlabel, *pmKey;
  QRadioButton  *PAPButton, *CHAPButton;
  QVBoxLayout   *AuthVBox;
     
  public:
  
  QLineEdit     *User, *Password;
  
  AuthWidget(QWidget *parent = 0, const char *name = 0);

  private slots:
  
  void slotAuthChanged(int);
};


#endif
