#include "prefdlg.h"
#include "pixmaps/screen.xpm"


AccountWidget::AccountWidget(QWidget *parent, const char *name):QWidget(parent, name)
{
  GBox = new QGroupBox(this);
  GBox->setGeometry(10, 8, 328, 314);
  GBox->setTitle(klocale->translate("Account Setup"));
  
  pmScreen = new QLabel(this);
  pmScreen->setPixmap(screen_xpm);
  pmScreen->setGeometry(278, 26, 48, 48);
  
  acclist = new QListBox(this);
  acclist->setGeometry(30, 90, 180, 132);
  if (ISDNData.FirstAccount != (AccData *) 0L)
  {
    AccData *actual = ISDNData.FirstAccount;
    
    do
    {
      acclist->insertItem(actual->providername);
      actual = actual->next;
    } while (actual != (AccData *) 0L);
  }

  pushnew = new QPushButton(klocale->translate("New..."), this);
  pushnew->setGeometry(227, 90, 94, 28);
  connect(pushnew, SIGNAL(clicked()), SLOT(slotNewAccount()));

  pushedit = new QPushButton(klocale->translate("Edit..."), this);
  pushedit->setGeometry(227, 125, 94, 28);
  connect(pushedit, SIGNAL(clicked()), SLOT(slotEditAccount()));

  pushcopy = new QPushButton(klocale->translate("Copy"), this);
  pushcopy->setGeometry(227, 160, 94, 28);
  connect(pushcopy, SIGNAL(clicked()), SLOT(slotCopyAccount()));
  
  pushdel = new QPushButton(klocale->translate("Delete"), this);
  pushdel->setGeometry(227, 195, 94, 28);
  connect(pushdel, SIGNAL(clicked()), SLOT(slotDeleteAccount()));
}


void AccountWidget::slotNewAccount(void)
{
  ISDNData.Current = new AccData();
  if (ISDNData.FirstAccount == (AccData *) 0L)
  {  
    ISDNData.FirstAccount = ISDNData.Current;
    ISDNData.LastAccount  = ISDNData.Current;
  }
  else
  {  
    (ISDNData.LastAccount)->next = ISDNData.Current;
    (ISDNData.Current)->prev     = ISDNData.LastAccount;
    ISDNData.LastAccount         = ISDNData.Current;
  }
  
  int Choice = execAccDialog(NEW);

  if (Choice != QDialog::Accepted)
  {
    if (ISDNData.FirstAccount == ISDNData.Current)
    {
      ISDNData.FirstAccount = (AccData *) 0L;
      ISDNData.LastAccount  = (AccData *) 0L;
    }
    else
    {
      ISDNData.LastAccount         = (ISDNData.Current)->prev;
      (ISDNData.LastAccount)->next = (AccData *) 0L; 
    }
    delete ISDNData.Current;
  }
  else acclist->insertItem((ISDNData.Current)->providername.data());
}


void AccountWidget::slotEditAccount(void)
{
  int help, index = acclist->currentItem();
  
  if (index > -1)
  {
    AccData *actual = ISDNData.FirstAccount;
    help = index;
    
    do
    {
      ISDNData.Current = actual;
      actual           = actual->next;
      index--;
    } while ((index > -1) && (actual != (AccData *) 0L));
    
    (ISDNData.Current)->Backup();    
    int Choice = execAccDialog(EDIT);  
    if (Choice != QDialog::Accepted) (ISDNData.Current)->Restore();
    else acclist->changeItem((ISDNData.Current)->providername.data(), help);
  }
}


void AccountWidget::slotCopyAccount(void)
{
  // TODO: Copy slave device list 
  
  int      help, index = acclist->currentItem();
  QString  temp;  
  AccData  *orig, *copy;
  DevData  *ordv, *cpdv;
  DNSData  *ordns, *cpdns, *dns;
  
  if (index > -1)
  {
    AccData *actual = ISDNData.FirstAccount;
    help = index;
    
    do
    {
      ISDNData.Current = actual;
      actual           = actual->next;
      index--;
    } while ((index > -1) && (actual != (AccData *) 0L));
   
    orig = ISDNData.Current;
    copy = new AccData();
    
    (ISDNData.LastAccount)->next = copy;
    copy->prev                   = ISDNData.LastAccount;
    ISDNData.LastAccount         = copy;

    temp                = orig->providername.copy();    
    temp               += "_copy";
    copy->providername  = temp;
    copy->device        = orig->device;
    copy->bundle        = orig->bundle;
    copy->ipdynamic     = orig->ipdynamic;    
    copy->iplocaddress  = orig->iplocaddress.copy();    
    copy->ipremaddress  = orig->ipremaddress.copy();    
    copy->subnetmask    = orig->subnetmask.copy();
    copy->domain        = orig->domain.copy();
    copy->UsePAP        = orig->UsePAP;
    copy->UseCHAP       = orig->UseCHAP;
    copy->username      = orig->username.copy();
    copy->password      = orig->password.copy();
    
    ordv = &orig->MasterDevice;
    cpdv = &copy->MasterDevice;
    
    cpdv->HupTimeout   = ordv->HupTimeout;
    cpdv->DialAttempts = ordv->DialAttempts;
    cpdv->Delay        = ordv->Delay;
    cpdv->Encaps       = ordv->Encaps;
        
    ordns = orig->FirstDNS;
    cpdns = copy->FirstDNS;
    
    while (ordns != (DNSData *) 0L)
    {
      dns = new DNSData();
      if (cpdns == (DNSData *) 0L) copy->FirstDNS = dns;
      else
      {
        dns->prev   = cpdns;
	cpdns->next = dns;
      }
      copy->LastDNS  = dns;    
      dns->ipaddress = ordns->ipaddress.copy();      
      ordns          = ordns->next;
      cpdns          = dns;
    }  
    acclist->insertItem(copy->providername.data());
    acclist->setCurrentItem(acclist->count()-1);
  }
}


void AccountWidget::slotDeleteAccount(void)
{
  int help, index = acclist->currentItem();
  
  if (index > -1)
  {
    if (QMessageBox::warning(this, "Delete Account",
    				   "Do you really want to delete the\n"
				   "selected account ?\n\n",
				   "Delete", "Abort",
				   0, 1) == 0)
    {
      AccData *actual = ISDNData.FirstAccount;
      help = index;
    
      while (index > 0)
      {
        actual = actual->next;
        index--;
      }
    
      if (actual->next != (AccData *) 0L) (actual->next)->prev = actual->prev;
      else ISDNData.LastAccount = actual->prev;
      if (help == 0) ISDNData.FirstAccount = actual->next;
      else (actual->prev)->next = actual->next;
    
      delete actual;
      acclist->removeItem(help);
    }
  }
}


int AccountWidget::execAccDialog(ushort mode)
{   
  bool iplocok = false, ipremok = false, mskok = false, ispok = false;
  int  Choice;
  char buffer[NAMESIZE+1], *bufferp = buffer;
  
  AccDialog = new LogoTabDialog(10, 370, (QWidget *) 0, (const char *) 0);
  if (mode == NEW) AccDialog->setCaption(klocale->translate("New Account"));
  else AccDialog->setCaption(klocale->translate("Edit Account"));
  AccDialog->resize(360, 408);
  AccDialog->setCancelButton();

  DeviceTab = new DevicesWidget(AccDialog);
  IPTab     = new IPWidget(AccDialog);
  DNSTab    = new DNSWidget(AccDialog);
  AuthTab   = new AuthWidget(AccDialog);
  
  AccDialog->addTab(DeviceTab, klocale->translate("Devices"));
  AccDialog->addTab(IPTab, "IP");
  AccDialog->addTab(DNSTab, "DNS");
  AccDialog->addTab(AuthTab, "Auth");
  
  do
  {
    Choice = AccDialog->exec();
    if (Choice == QDialog::Accepted)
    {
      IP *iploc  = new IP((IPTab->IPloc)->text());
      iplocok = iploc->isValidIP();
      IP *iprem  = new IP((IPTab->IPrem)->text());
      ipremok = iprem->isValidIP();
      IP *msk = new IP((IPTab->Mask)->text());
      mskok = msk->isValidIP();
      if (!iplocok || !ipremok || !mskok) QMessageBox::warning(this, "Invalid IP number",
    	  		                  "You entered an invalid IP address.\n"    				   
		                          "Remember that an IP consists of\n"
					  "4 numbers in the range of 0..255,\n"
				          "separated by dots\n\n", "OK", 0);
      else
      {
        AccData *acc = ISDNData.Current;
      
        acc->providername = (DeviceTab->Provider)->text();
	acc->username     = (AuthTab->User)->text();
	acc->password     = (AuthTab->Password)->text();
    
        DevData *master = &(acc->MasterDevice);
    
        master->DialAttempts = atoi((DeviceTab->Attempts)->text());
        master->HupTimeout   = atoi((DeviceTab->HupTime )->text());

	if (iploc->isNull()) acc->iplocaddress = "";	
	else acc->iplocaddress = (IPTab->IPloc)->text();
	if (iprem->isNull()) acc->ipremaddress = "";
	else acc->ipremaddress = (IPTab->IPrem)->text();
	if (msk->isNull()) acc->subnetmask = "";
	else acc->subnetmask = (IPTab->Mask)->text();

	acc->domain = (DNSTab->Domain)->text();
        strncpy(buffer, acc->providername.data(), NAMESIZE);
	buffer[NAMESIZE] = '\0';
	while (*bufferp == ' ') bufferp++;
	ispok = (*bufferp != '\0');
	if (!ispok) QMessageBox::warning(this, "Invalid ISP",
    	  		                 "You must enter a name for your\n"    				   
		                         "internet provider.\n\n", "OK", 0);
      }
      delete iploc;
      delete iprem;
      delete msk;
    }
  } while ((Choice == QDialog::Accepted) && (!iplocok || !ipremok || !mskok || !ispok)); 
    
  delete AccDialog;  
  return (Choice);
}

