#include "prefdlg.h"
#include "pixmaps/roadsign.xpm"


CommandWidget::CommandWidget(QWidget *parent, const char *name):QWidget(parent, name)
{
  GBox = new QGroupBox(this);
  GBox->setGeometry(10, 8, 328, 314);
  GBox->setTitle(klocale->translate("Command Paths"));

  pmRoadSign = new QLabel(this);
  pmRoadSign->setPixmap(roadsign_xpm);
  pmRoadSign->setGeometry(278, 30, 43, 60);

  ctrlpathlabel = new QLabel(klocale->translate("isdnctrl Path:"), this);
  ctrlpathlabel->adjustSize();
  ctrlpathlabel->setGeometry(44, 110, ctrlpathlabel->width(), 24);
  ctrlpath = new QLineEdit(this);
  ctrlpath->setGeometry(135, 110, 172, 24);
  ctrlpath->setMaxLength(PATHSIZE);

  browse1 = new QPushButton(klocale->translate("Browse..."), this);
  browse1->setGeometry(234, 140, 74, 24);
  connect(browse1, SIGNAL(clicked()), SLOT(slotBrowseCtrl()));
  
  ipppdpathlabel = new QLabel(klocale->translate("ipppd Path:"), this);
  ipppdpathlabel->adjustSize();
  ipppdpathlabel->setGeometry(52, 176, ipppdpathlabel->width(), 24);
  ipppdpath = new QLineEdit(this);
  ipppdpath->setGeometry(135, 176, 172, 24);
  ipppdpath->setMaxLength(PATHSIZE);

  browse2 = new QPushButton(klocale->translate("Browse..."), this);
  browse2->setGeometry(234, 206, 74, 24);
  connect(browse2, SIGNAL(clicked()), SLOT(slotBrowseIpppd()));

  ifconpathlabel = new QLabel(klocale->translate("ifconfig Path:"), this);
  ifconpathlabel->adjustSize();
  ifconpathlabel->setGeometry(44, 242, ifconpathlabel->width(), 24);
  ifconpath = new QLineEdit(this);
  ifconpath->setGeometry(135, 242, 172, 24);
  ifconpath->setMaxLength(PATHSIZE);

  browse3 = new QPushButton(klocale->translate("Browse..."), this);
  browse3->setGeometry(234, 272, 74, 24);
  connect(browse3, SIGNAL(clicked()), SLOT(slotBrowseIfConfig()));

  refreshSettings();
}


void CommandWidget::slotBrowseCtrl(void)
{
  QFileDialog *Browser = new QFileDialog("/sbin", "isdnctrl", this, "", true);
  Browser->setCaption(klocale->translate("Choose isdnctrl Path"));

  QString CtrlSel;
  
  if (Browser->exec() == QDialog::Accepted) CtrlSel = Browser->selectedFile();
  if (!CtrlSel.isNull()) 
  {
    ctrlpath->setText(CtrlSel.data());
    // emit a SIGNAL here ?
  }
  
  delete (Browser);
}


void CommandWidget::slotBrowseIpppd(void)
{
  QFileDialog *Browser = new QFileDialog("/sbin", "ipppd", this, "", true);
  Browser->setCaption(klocale->translate("Choose ipppd Path"));

  QString IpppdSel;
  
  if (Browser->exec() == QDialog::Accepted) IpppdSel = Browser->selectedFile();
  if (!IpppdSel.isNull())
  {
    ipppdpath->setText(IpppdSel.data());
    // emit a SIGNAL here ?
  }
  
  delete (Browser);
}


void CommandWidget::slotBrowseIfConfig(void)
{
  QFileDialog *Browser = new QFileDialog("/sbin", "ifconfig", this, "", true);
  Browser->setCaption(klocale->translate("Choose ifconfig Path"));

  QString IfConfigSel;
  
  if (Browser->exec() == QDialog::Accepted) IfConfigSel = Browser->selectedFile();
  if (!IfConfigSel.isNull())
  {
    ifconpath->setText(IfConfigSel.data());
    // emit a SIGNAL here ?
  }
  
  delete (Browser);
}


void CommandWidget::refreshSettings(void)
{
  GenData *gen = ISDNData.General;
  
  ctrlpath->setText(gen->ctrlpath.data());
  ipppdpath->setText(gen->ipppdpath.data());
  ifconpath->setText(gen->ifconpath.data());
}
