#include "accdlg.h"
#include "pixmaps/phone.xpm"


DevicesWidget::DevicesWidget(QWidget *parent, const char *name):QWidget(parent, name)
{
  char buffer[8];
  
  GBoxM = new QGroupBox(this);
  GBoxM->setGeometry(10, 8, 324, 316);
  GBoxM->setTitle(klocale->translate("Master Device"));
  
  Provlabel = new QLabel(klocale->translate("Provider Name:"), this);
  Provlabel->setGeometry(24, 36, 100, 24);
  Provider = new QLineEdit(this);
  Provider->setGeometry(120, 36, 140, 24);
  Provider->setMaxLength(NAMESIZE);
  Provider->setText((ISDNData.Current)->providername);

  pmPhone = new QLabel(this);
  pmPhone->setPixmap(phone_xpm);
  pmPhone->setGeometry(284, 32, 34, 29);
  
  Remotelabel = new QLabel(klocale->translate("Remote Phone:"), this);
  Remotelabel->setGeometry(24, 74, 100, 24);
  
  Remote = new QLineEdit(this);
  Remote->setGeometry(120, 76, 100, 24);
  Remote->setMaxLength(PNUMSIZE);
  
  Addbutton = new QPushButton(klocale->translate("Add"), this);
  Addbutton->setGeometry(232, 75, 88, 28);
  
  Listlabel = new QLabel(klocale->translate("Phone List:"), this);
  Listlabel->setGeometry(24, 110, 100, 24);
  
  Phonelist = new QListBox(this);
  Phonelist->setGeometry(120, 110, 100, 52);
  
  DevData *dev = &((ISDNData.Current)->MasterDevice);
  if (dev->FirstPhone != (PhoneData *) 0L)
  {
    PhoneData *actual = dev->FirstPhone;
    
    while (actual != (PhoneData *) 0L)
    {
      Phonelist->insertItem(actual->number.data());
      actual = actual->next;
    }
  }  
  
  connect(Addbutton, SIGNAL(clicked()), SLOT(slotAddRemote()));  
  Removebutton = new QPushButton(klocale->translate("Remove"), this);
  Removebutton->setGeometry(232, 110, 88, 28);
  connect(Removebutton, SIGNAL(clicked()), SLOT(slotRemoveRemote()));
  
  Encapslabel = new QLabel(klocale->translate("Encapsulation:"), this);
  Encapslabel->setGeometry(24, 172, 100, 24);

  Encapsbox = new QComboBox(false, this, "encapsCombo");
  Encapsbox->insertItem(klocale->translate("Raw IP"));  
  Encapsbox->insertItem(klocale->translate("Internet Protocol"));
  Encapsbox->insertItem(klocale->translate("Cisco / HDLC Mode")); 
  Encapsbox->insertItem(klocale->translate("Ethernet"));
  Encapsbox->insertItem(klocale->translate("Synchronous PPP")); 
  Encapsbox->insertItem(klocale->translate("Raw IP + UI Header"));      
  Encapsbox->setGeometry(120, 172, 150, 24);
  Encapsbox->setCurrentItem(((ISDNData.Current)->MasterDevice).Encaps);
  connect(Encapsbox, SIGNAL(activated(int)), SLOT(slotEncapsChanged(int)));
 
  Layer2label = new QLabel(klocale->translate("Layer 2:"), this);
  Layer2label->setGeometry(24, 200, 80, 24);
  Layer2box = new QComboBox(false, this);
  Layer2box->insertItem(klocale->translate("X75I"));  
  Layer2box->insertItem(klocale->translate("X75UI"));
  Layer2box->insertItem(klocale->translate("X75BUI")); 
  Layer2box->insertItem(klocale->translate("HDLC"));
  Layer2box->setGeometry(120, 200, 100, 24);
  Layer2box->setCurrentItem(((ISDNData.Current)->MasterDevice).Layer2);
  connect(Layer2box, SIGNAL(activated(int)), SLOT(slotLayer2Changed(int)));
   
  Layer3label = new QLabel(klocale->translate("Layer 3:"), this);
  Layer3label->setGeometry(24, 228, 80, 24);
  Layer3box = new QComboBox(false, this);
  Layer3box->insertItem(klocale->translate("Trans"));  
  Layer3box->setGeometry(120, 228, 100, 24);
  Layer3box->setCurrentItem(((ISDNData.Current)->MasterDevice).Layer3);
  connect(Layer3box, SIGNAL(activated(int)), SLOT(slotLayer3Changed(int)));

  Diallabel = new QLabel(klocale->translate("Dial attempts:"), this);
  Diallabel->setGeometry(24, 262, 100, 24);

  Attempts = new QLineEdit(this);
  Attempts->setGeometry(120, 262, 30, 24);
  Attempts->setMaxLength(DATMSIZE);
  sprintf(buffer, "%i", dev->DialAttempts);
  Attempts->setText(buffer);
   
  HupTimelabel = new QLabel(klocale->translate("Timeout:"), this);
  HupTimelabel->setGeometry(170, 262, 50, 24);
  
  HupTime = new QLineEdit(this);
  HupTime->setGeometry(224, 262, 44, 24);
  HupTime->setMaxLength(TIMESIZE);
  sprintf(buffer, "%i", dev->HupTimeout);
  HupTime->setText(buffer);
  
  Sec1label = new QLabel(klocale->translate("seconds"), this);
  Sec1label->setGeometry(274, 262, 50, 24);

  Bundlecheck = new QCheckBox(klocale->translate("Bundle Channels"),this);
  Bundlecheck->adjustSize();
  Bundlecheck->setGeometry(24, 298, Bundlecheck->width(), Bundlecheck->height());
  Bundlecheck->setChecked((ISDNData.Current)->bundle);
  connect(Bundlecheck, SIGNAL(clicked()), SLOT(slotBundleClicked())); 
  
  Delaylabel = new QLabel(klocale->translate("Delay:"), this); 
  Delaylabel->setGeometry(170, 294, 50, 24);

  Delay = new QLineEdit(this);
  Delay->setGeometry(224, 294, 44, 24);
  Delay->setMaxLength(TIMESIZE);
  sprintf(buffer, "%i", dev->Delay);
  Delay->setText(buffer);

  Sec2label = new QLabel(klocale->translate("seconds"), this);
  Sec2label->setGeometry(274, 294, 50, 24);
  
  setBundleState();
}


void DevicesWidget::slotAddRemote(void)
{
  char buffer[PNUMSIZE+1];
  uint len;
  boolean invalidIP = false;
  
  strncpy(buffer, Remote->text(), PNUMSIZE+1);
  buffer[PNUMSIZE] = '\0';
  len=strlen(buffer);
  
  QString tmp = Remote->text();				/* ###### Subject to revision ###### */
  
  if (tmp.isEmpty()) invalidIP = true;

  for (uint i = 0; i < len; i++)
  {
    if (!isdigit(buffer[i]))
    {
      invalidIP = true;
      break;
    }
  }			     
	
  if ( invalidIP )
  {     
    QMessageBox::warning(this, "Invalid phone number",
                               "Please enter only legal phone\n"                                 
                               "numbers.\n\n", "OK", 0);
    return;
  }
  		     
  DevData *actdev = &((ISDNData.Current)->MasterDevice);
  
  actdev->CurrPhone = new PhoneData();
  if (actdev->FirstPhone != (PhoneData *) 0L)
  {
    (actdev->CurrPhone)->prev = actdev->LastPhone;
    (actdev->LastPhone)->next = actdev->CurrPhone;
  }
  else actdev->FirstPhone = actdev->CurrPhone;
  
  actdev->LastPhone = actdev->CurrPhone;
  (actdev->CurrPhone)->number = Remote->text();
  Phonelist->insertItem((actdev->CurrPhone)->number.data());
  Remote->setText("");
}
  
  
void DevicesWidget::slotRemoveRemote(void)
{
  int      help, index = Phonelist->currentItem();
  DevData  *currdev = &((ISDNData.Current)->MasterDevice);
  
  if (index > -1)
  {
    PhoneData *actual = currdev->FirstPhone;
    help = index;
    
    while (index > 0)
    {
      actual = actual->next;
      index--;
    }
    
    if (actual->next != (PhoneData *) 0L) (actual->next)->prev = actual->prev;
    else currdev->LastPhone = actual->prev;
    if (help == 0) currdev->FirstPhone = actual->next;
    else (actual->prev)->next = actual->next;
    
    Phonelist->removeItem(help);
  }
}


void DevicesWidget::slotEncapsChanged(int Choice)
{
  ((ISDNData.Current)->MasterDevice).Encaps = Choice;
}


void DevicesWidget::slotLayer2Changed(int Choice)
{
  ((ISDNData.Current)->MasterDevice).Layer2 = Choice;  
}


void DevicesWidget::slotLayer3Changed(int Choice)
{
  ((ISDNData.Current)->MasterDevice).Layer3 = Choice;  
}


void DevicesWidget::slotBundleClicked(void)
{
  (ISDNData.Current)->bundle = Bundlecheck->isChecked();
  setBundleState();
}


void DevicesWidget::setBundleState(void)
{
  bool state = (ISDNData.Current)->bundle;
  
  Delaylabel->setEnabled(state);
  Delay->setEnabled(state);
  Sec2label->setEnabled(state);
}


void DevicesWidget::Backup(void)
{

}


void DevicesWidget::Restore(void)
{

}
