#include "accdlg.h"
#include "pixmaps/mail.xpm"


IPWidget::IPWidget(QWidget *parent, const char *name):QWidget(parent, name)
{
  GBox = new QGroupBox(this);
  GBox->setGeometry(10, 8, 323, 316);
  GBox->setTitle(klocale->translate("IP Setup"));

  pmMail = new QLabel(this);
  pmMail->setPixmap(mail_xpm);
  pmMail->setGeometry(270, 30, 47, 25);

  IPGBox = new QGroupBox(this);
  IPGBox->setGeometry(35, 77, 270, 134);
  IPGBox->setTitle("        ");
  
  IPGroup = new QButtonGroup(this);
  IPGroup->setLineWidth(0);
  IPVBox = new QVBoxLayout(IPGroup, 10);
  IPGroup->move(44, 36);

  Etched = new QFrame(this);
  Etched->setFrameStyle(0x34);
  Etched->setLineWidth(2);
  Etched->setGeometry(178, 84, 20, 2);
  
  DynButton = new QRadioButton(IPGroup);
  DynButton->setText(klocale->translate("Dynamic IP Address"));
  DynButton->setChecked((ISDNData.Current)->ipdynamic);
  IPVBox->addWidget(DynButton);
  DynButton->setMinimumSize(DynButton->sizeHint());
  
  StatButton = new QRadioButton(IPGroup);
  StatButton->setText(klocale->translate("Static IP Address"));
  StatButton->setChecked(!(ISDNData.Current)->ipdynamic);
  IPVBox->addWidget(StatButton);
  StatButton->setMinimumSize(StatButton->sizeHint());
  
  IPVBox->activate();

  connect(IPGroup, SIGNAL(clicked(int)), SLOT(slotRButtonClicked(int))); 

  IPloclabel = new QLabel(klocale->translate("Local IP Address:"), this);
  IPloclabel->setGeometry(50, 100, 110, 24);

  IPremlabel = new QLabel(klocale->translate("Remote IP Address:"), this);
  IPremlabel->setGeometry(50, 132, 110, 24); 
  
  Masklabel = new QLabel(klocale->translate("Subnet Mask:"), this);
  Masklabel->setGeometry(50, 170, 110, 24);
  
  IPloc = new QLineEdit(this);
  IPloc->setGeometry(190, 100, 100, 24);
  IPloc->setMaxLength(IPNMSIZE);
 
  IPrem = new QLineEdit(this);
  IPrem->setGeometry(190, 132, 100, 24);
  IPrem->setMaxLength(IPNMSIZE);

  Mask = new QLineEdit(this);
  Mask->setGeometry(190, 170, 100, 24);
  Mask->setMaxLength(IPNMSIZE);
  
  setIPStatic(!(ISDNData.Current)->ipdynamic);
}


void IPWidget::setIPStatic(bool IPstatic)
{
  IPloclabel->setEnabled(IPstatic);
  IPloc->setEnabled(IPstatic);
  IPremlabel->setEnabled(IPstatic);
  IPrem->setEnabled(IPstatic);
  Masklabel->setEnabled(IPstatic);
  Mask->setEnabled(IPstatic);
  
  if (!IPstatic)
  {
    IPloc->setText("0.0.0.0");
    IPrem->setText("0.0.0.0");
    Mask->setText("0.0.0.0");
  }
  else
  {
    IPloc->setText((ISDNData.Current)->iplocaddress.data());
    IPrem->setText((ISDNData.Current)->ipremaddress.data());
    Mask->setText((ISDNData.Current)->subnetmask.data());
  }
}


void IPWidget::slotRButtonClicked(int Button)
{
  bool IPstatic = (bool)Button;
  
  (ISDNData.Current)->ipdynamic   = !IPstatic;
  if (IPstatic)
  {
    (ISDNData.Current)->iplocaddress  = "";
    (ISDNData.Current)->ipremaddress  = "";
    (ISDNData.Current)->subnetmask    = "";
  }
  setIPStatic(IPstatic);
}  
