#ifndef __KISDN_H
#define __KISDN_H

#include <kbutton.h>
#include "connection.h"
#include "display.h"


class MyLabel : public QLabel
{
  public:
  
  MyLabel(uint, uint, const char *, QWidget *parent = 0, const char *name = 0);
};


class LED : public QLabel
{
  ushort   state, color;

  QPixmap  pixmap;
  
  public:
   
  LED(ushort, uint, uint, QWidget *parent = 0, const char *name = 0);
  void set();
  void clear();
  ushort LEDstate() {return (state);}
};


class PasswordDialog : public QDialog
{
  QLabel       *PasswordLabel;
  QLineEdit    *Password;
  QPushButton  *Ok, *Cancel;
  
  public:
  
  PasswordDialog(QWidget *parent = 0, const char *name = 0);
};


class Monitor : public QDialog
{    
  Q_OBJECT
  
  LED             *On[2], *Rx[2], *Tx[2], *Dial[2];
  MyLabel         *Label;
  ulong           Clock[2], Received[2], Transmitted[2];
  AccountWidget   *Account, provider;
  GeneralWidget   *General;
  CommandWidget   *Commands;
  DriverWidget    *Driver;
  LoggingWidget   *Logging;
  AboutWidget     *About;	    
  ushort          Device[2];             // Reference Channel->Device
  bool            modloaded, modchanged;
  Connection      *Connect[2];

  QComboBox      *ServerCombo[2];
  QFrame         *EtchedLine;
  QLabel         *Logo;
  QPushButton    *PushConnect[2], *PushSetup, *PushHelp, *PushDock, *PushQuit;  
  QTimer         *Pulse;
  
  LogoTabDialog  *PrefDlg;
  
  KLocale        *locale;
  KProcess       *IPPPD;
  
  bool demandPassword();
  void messageBadPassword();
  void checkOnline(boolean *, boolean *);
  void checkTraffic(boolean *, boolean *);
  void writeCombo(ushort);
  void setEnableHide(bool);
  void locateAccount(int);
  void insertModule();
  void removeModule();
  bool writeScripts();
  void messageBadSysValues();
  void messageCantOpenFile(const char *);
  void messageNoDNSSupplied();
  bool providerChanged(ushort, int);
  void messageNoAccSelected();
  
  public:

  Monitor(QWidget *parent = 0, const char *name = 0);
  ~Monitor();
  
  bool isOnline();
  int onlineChannels(); // -1 = NC; 0 = channel 0; 1 = channel 1; 2 = both connected
  void dialUp(ushort);
  void hangUp(ushort);
  void playSound( ushort );
   
  private slots:
  
  void slotProviderAChanged(int);
  void slotProviderBChanged(int);
  void slotTakeActionA();
  void slotTakeActionB();
  void slotCallProvider(int);
  void slotDockMainMenu(int);
  void slotCheckStatus();
  void slotSetPreferences();
  void slotInvokeHelp();
  void slotMinimize();
  void slotQuit();
};


class DockedWin : public QLabel
{
  Q_OBJECT
  
  public:
  
  QPopupMenu   *menu, *subMenu;

  DockedWin(const char *name = 0);

  void showToolTip();
  void showToolTip( QString );
  void launchConfig();
 
  public slots:
  
  void slotPopupMenu();

  signals:
  
  void rightClick();
  void leftClick();
};

DockedWin   *Docked;
Monitor     *ISDNmon;
MyDisplay   *myDisplay;

#endif
