/* apmlib.c -- Sample APM interface routines
 * Created: Mon Jan  8 10:28:16 1996 by faith@acm.org
 * Revised: Fri Dec 26 21:38:29 1997 by faith@acm.org
 * Copyright 1996, 1997 Rickard E. Faith (faith@acm.org)
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: apmlib.c,v 1.8 1998/09/12 18:28:42 apenwarr Exp $
 * 
 */

// Cheaply converted to C++ and stripped down Apr 20, 1999 by Ryan Cumming

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <ctype.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/sysmacros.h>
#include "apm.h"

/* If APM support of the right version exists in kernel, return zero.
   Otherwise, return 1 if no support exists, or 2 if it is the wrong
   version.  *NOTE* The sense of the return value is not intuitive. */

int apm_exists( void )
{
   apm_info i;
   
   if (access( APM_PROC, R_OK )) return 1;
   return apm_read( &i );
}

/* Read information from /proc/apm.  Return 0 on success, 1 if APM not
   installed, 2 if APM installed, but old version. */

int apm_read( apm_info *i )
{
   FILE *str;
   char units[10];
   char buffer[100];
   int  retcode = 0;

   if (!(str = fopen( APM_PROC, "r" ))) return 1;
   fgets( buffer, sizeof( buffer ) - 1, str );
   buffer[ sizeof( buffer ) - 1 ] = '\0';
   sscanf( buffer, "%s %d.%d %x %x %x %x %d%% %d %s\n",
	   (char *)i->driver_version,
	   &i->apm_version_major,
	   &i->apm_version_minor,
	   &i->apm_flags,
	   &i->ac_line_status,
	   &i->battery_status,
	   &i->battery_flags,
	   &i->battery_percentage,
	   &i->battery_time,
	   units );
   i->using_minutes = !strncmp( units, "min", 3 ) ? 1 : 0;
   if (i->driver_version[0] == 'B') { /* old style.  argh. */
      retcode = 2;
   }

   fclose( str );
   return retcode;
}


/* Lookup the device number for the apm_bios device. */

dev_t apm_dev( void )
{
   FILE       *str;
   static int cached = -1;
   char       buf[80];
   char       *pt;
   apm_info  i;

   if (cached >= 0) return cached;

   if (access( APM_PROC, R_OK ) || apm_read( &i ) == 1) return cached = -1;
   if (i.driver_version[0] == '1') return cached = makedev( 10, 134 );

   if (!(str = fopen( APM_DEV, "r" ))) return -1;
   while (fgets( buf, sizeof( buf ) - 1, str )) {
      buf[ sizeof( buf ) - 1 ] = '\0';
      for (pt = buf; *pt && isspace( *pt ); ++pt); /* skip leading spaces */
      for (; *pt && !isspace( *pt ); ++pt); /* find next space */
      if (isspace( *pt )) {
	 *pt++ = '\0';
	 pt[ strlen( pt ) - 1 ] = '\0';	/* get rid of newline */
	 if (!strcmp( pt, APM_NAME )) {
	    fclose( str );
	    return cached = makedev( atoi( buf ), 0 );
	 }
      }
   }
   fclose( str );
   return cached = -1;
}


/* Return a file descriptor for the apm_bios device, or -1 if there is an
   error.  Is this method secure?  Should we make the device in /dev
   instead of /tmp? */

int apm_open( void )
{
   int      fd = -1;
   apm_info i;

   if (access( APM_PROC, R_OK ) || apm_read( &i ) == 1) return -1;
   if (i.driver_version[0] == '1') {
      fd = open( APM_DEVICE, O_RDWR );
   }
   
   return fd;
}








