/* apm.h -- Header file for sample APM interface routines
 * Created: Mon Jan  8 11:40:50 1996 by r.faith@ieee.org
 * Revised: Mon Aug  2 23:57:43 1999 by bodnar42@bodnar42.dhs.org
 * Copyright 1996 Rickard E. Faith (r.faith@ieee.org)
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#include <linux/apm_bios.h>
#include <sys/types.h>

#define APM_PROC   "/proc/apm"
#define APM_DEVICE "/dev/apm_bios"

#ifndef APM_32_BIT_SUPPORT
#define APM_32_BIT_SUPPORT      0x0002
#endif

typedef struct apm_info {
   char 			driver_version[10];
   int        apm_version_major;
   int        apm_version_minor;
   int        apm_flags;
   int        ac_line_status;
   char       battery_status;
   int        battery_flags;
   int        battery_percentage;
   int        battery_time;
   int        using_minutes;
} apm_info;

extern int apmCheck();
extern void apmRead();
extern dev_t apmDev();
extern int   apmOpen();

extern apm_info i;











