/***************************************************************************
                          cchoixfichier.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Jun 3 1999                                           
    copyright            : (C) 1999 by Eric Coquelle                         
    email                : coquelle@hivaoa.unice.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qwidget.h>
#include "cchoixfichier.h"

CChoixFichier::CChoixFichier(QWidget *parent, const char *name )
	: QWidget( parent, name )
{
	repertoire=QDir::home();
	boitedlg=new KFileDialog(repertoire.path());
	filtre="*.lha *.lzh *.rar *.gz *.bz2 *.zip *.tar *.tgz *.Z";
}

CChoixFichier::~CChoixFichier(){
	delete boitedlg;
}

void CChoixFichier::initialise()
{
	decompresseur="";
	listeur="";
	fichierchoisit="";
}

const char* CChoixFichier::OuvreFichier()
{
	fichierchoisit=boitedlg->getOpenFileName(repertoire.path(),filtre);
  //We set the last open directory
  repertoire=fichierchoisit.left(fichierchoisit.findRev('/'));
	return (const char*)fichierchoisit;
}

int CChoixFichier::IdentifieCompresseur()
{
	QString archive;
	
	if(fichierchoisit.isNull())
		return 2;

	archive=fichierchoisit.lower();

	progrCompresseur="tar";
	optionSupp="";
	compresserconcatener="";

	if((archive.right(7)==".tar.gz")||(archive.right(6)==".tar.z")||(archive.right(4)==".tgz"))
		{
			decompresseur="-zvxf";
			listeur="-zvtf";
			compresserconcatener="-r";
		}
	else if(archive.right(8)==".tar.bz2")
		{
			optionSupp="--use-compress-program=bzip2";
			decompresseur="-vxf";
			listeur="-vtf";
		}
	else if(archive.right(4)==".zip")
		{
			progrCompresseur="unzip";
			listeur="-lv";
			decompresseur="";
		}
	else if(archive.right(4)==".tar")
	{
		listeur="-vtf";
		decompresseur="-vxf";
	}
	else if(archive.right(3)==".gz")
	{
		progrCompresseur="gzip";
		listeur="-lv";
		decompresseur="-dv";
	}
	else if(archive.right(4)==".bz2")
	{
		progrCompresseur="bzip2";
		listeur="";
		decompresseur="-dvk";
	}
	else if(archive.right(4)==".rar")
	{
		progrCompresseur="unrar";
		listeur="l";
		decompresseur="x";
	}
	else if((archive.right(4)==".lzh")||(archive.right(4)==".lha"))
	{
		progrCompresseur="lha";
		listeur="l";
		decompresseur="x";
	}	
	else
		return 1;
	return 0;
}

const char* CChoixFichier::getCompresseur()
{
	return (const char*)compresseur;
}

const char* CChoixFichier::getDecompresseur()
{
	return (const char*)decompresseur;
}

const char* CChoixFichier::getListeur()
{
	return (const char*)listeur;
}

const char* CChoixFichier::getNomFichier()
{
	return (const char*)fichierchoisit;
}

const char* CChoixFichier::getProgrCompresseur()
{
	return (const char*)progrCompresseur;
}

const char* CChoixFichier::getOptionSupp()
{
	return (const char*) optionSupp;
}

const char* CChoixFichier::getConcateneur()
{
	return (const char*) compresserconcatener;
}

void CChoixFichier::setNomArchive(QString archive)
{
  fichierchoisit=archive;
}


/** Set the acess path when opening an archive */
void CChoixFichier::setCheminAcces(const char* chemin){
	repertoire=chemin;
	if(!repertoire.isReadable())
		repertoire=QDir::home();
}

/** return the directory's path of the opened file */
const char* CChoixFichier::getCheminAcces(){
	return repertoire.path();
}

/** Define the default path when opening a file
0: Last dir
1: home dir
2: shell's one */
void CChoixFichier::setCheminAcces(const char* chemin, int optionOuverture){
	switch(optionOuverture)
	{
		case 0:
			setCheminAcces(chemin);
			break;
		case 1:
			repertoire=QDir::home();
			break;
		case 2:
			repertoire.setPath("");
			break;
	}
}
