/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) YEAR by AUTHOR                         
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "cwizardstep2cutt.h"

CWizardStep2Cutt::CWizardStep2Cutt(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();

	//Additionnal init
	QLabel_Wiz->setBackgroundPixmap(QPixmap(Icon("karchiveur_wizard.xpm")));
	setCaption(i18n("karchiveur cutt step 3"));
	
	slotActiveTexte(0);
	type=0;
	
	connect(boutonPrecedent, SIGNAL(clicked()), this, SLOT(reject()));
	connect(boutonSuivant, SIGNAL(clicked()), this, SLOT(slotChoixFichierRepertoire()));
	connect(QButtonGroup_1, SIGNAL(clicked(int)), this, SLOT(slotActiveTexte(int)));	
}

CWizardStep2Cutt::~CWizardStep2Cutt(){
}

/** Set an appropriate text to the labels */
void CWizardStep2Cutt::slotActiveTexte(int valeur)
{
	type=valeur;	
	if(valeur==0)
	{	
		labelUn->setText(i18n("Next Step: please choose where"));
		labelDeux->setText(i18n("to store the splited files"));
	}
	else
	{	
		labelUn->setText(i18n("Next Step: please choose the first"));
		labelDeux->setText(i18n("splited file (ends with .01)"));		
	}	
}

/* Get the directory where to store the splited files */
void CWizardStep2Cutt::choixRepertoire()
{
	QDir d;
	
	rep=KDirDialog::getDirectory(QDir::homeDirPath());

	if((rep=="")||(rep==NULL))
		reject();
		
	d.setPath(rep);
	if(d.isReadable())
		accept();
	else
		reject();
}

/* Get the first of the splited files */
void CWizardStep2Cutt::choixFichier()
{
	rep=KFileDialog::getOpenFileName (NULL, "*.01");
	
	if((rep!="")&&(rep!=NULL))
		accept();
	else
		reject();
}

void CWizardStep2Cutt::slotChoixFichierRepertoire()
{
	if(type==0)
		choixRepertoire();
	else
		choixFichier();
}