#ifndef KBIFF_H
#define KBIFF_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif //HAVE_CONFIG_H

#include <qmovie.h>
#include <kapp.h>
#include <kwm.h>
#include <qwidget.h>
#include <qdatetm.h>
#include <qpixmap.h>
#include <qpopmenu.h>
#include <qpainter.h>
#include <qfileinf.h>
#include <qtooltip.h>

// needed for DwPopClient
#include <mimelib/mimepp.h>

// mediatool.h is needed by kaudio.h
extern "C" {
#include <mediatool.h>
} 

#include <kaudio.h>
#include <kmsgbox.h>

#include <stdlib.h>
#include <unistd.h>
#include <signal.h>

#include "setupdlg.h"

class KBiff : public QLabel
{
	Q_OBJECT

public:

	KBiff(QWidget* parent = 0);
	~KBiff();

	bool isDocked() { return m_isDocked; }
	bool readConfig(const char* profile = 0);

signals:
	void checkNewMail();

protected slots:
	void m_movieStatus(int);
	void m_saveYourself();
	bool m_setup();
	void m_resetState();
	void m_dock();
	void m_help();

	void m_checkMailNow();
	void m_checkLocalMail();
	void m_checkPOPMail();

protected:
	void timerEvent(QTimerEvent *);
	void mousePressEvent(QMouseEvent *);

	void m_popupMenu(int x, int y);

private:
	QMovie m_movie;

	void m_displayPixmap(bool force_pixmap = false);

	KAudio m_audioServer;
	bool m_hasAudio;

	bool m_readLocalMailbox;
	QString m_mailboxPath;
	QString m_popServer;
	QString m_username;
	QString m_password;
	int m_popPort;

	QString m_command;
	int m_poll;
	QString m_noMailPixmapPath;
	QString m_newMailPixmapPath;
	QString m_oldMailPixmapPath;
	QString m_name;

	bool m_beep;
	bool m_runCommand;
	bool m_playSound;
	bool m_sessionManagement;
	QString m_runCommandPath;
	QString m_playSoundPath;

	int m_getPopSize();

	QPixmap m_noMailPixmap;
	QPixmap m_newMailPixmap;
	QPixmap m_oldMailPixmap;

	QDateTime m_lastRead;
	int       m_lastSize;
	int       m_storedSize;

	int m_timerID;

	typedef enum 
	{
		NEW_MAIL,
		NO_MAIL,
		OLD_MAIL
	} MAILSTATE;

	MAILSTATE m_mailState;

	bool m_isDocked;

	KBiffScramble m_scramble;
};
#endif // KBIFF_H
