#include <iostream.h>

#include "kbootselwidget.h"

KBootSelWidget::KBootSelWidget ( LiloInfo *lilo, QWidget *parent, const char *name )
	: QWidget(parent, name)
{
	// Keep a handle to the parent of this widget
	mainWindow = (KBootSel *)parent;

	// Initialize the options array
	options = 0;

	// Create the main layout with a border of 10 pixels
	layout = new QVBoxLayout ( this, 10 );

	// Create a button group and add it to the main layout
	grp_select = new QButtonGroup ( i18n("Select boot option"), this );
	layout->addWidget ( grp_select, 2 );

	// The radio buttons will have an own layout manager, which has the button group
	// as parent
	lay_buttons = new QVBoxLayout ( grp_select, 10 );

	lay_buttons->addSpacing ( grp_select->fontMetrics().height() );

	// Initialize the radioList array
	for ( int i = 0; i < MAX_OPTIONS; i++ ) radioList[i] = 0;

	// Setup the contents of the button group
	liloResult = setupBootOptions ( lilo );

	// Activate the layout of the buttons
	lay_buttons->activate();

	// Add a checkbox to the main layout
	chk_logout = new QCheckBox ( i18n("Logout on activate"), this );
	chk_logout->setMinimumSize ( chk_logout->sizeHint() );
	chk_logout->setMaximumHeight ( chk_logout->sizeHint().height() );
	layout->addWidget ( chk_logout );

	// The tooltip for the checkbox...
	QToolTip::add ( chk_logout, i18n("Checking this will logout KDE after activating the new boot option.") );

	// Activate the main layout
	layout->activate();
}

KBootSelWidget::~KBootSelWidget()
{
}

/*
 * Setup the contents of the button group
 */
int KBootSelWidget::setupBootOptions ( LiloInfo *lilo )
{
	int result;

	// Initialize the options array
	options = new QStrList();

	// Fill the options array with information from the LiloInfo object
	result = lilo->getBootOptions ( options );
	// If that failed, return (the caller must handle the error)
	if ( result < 0 ) return result;

	// Get the index of the default option
	int defaultOption = lilo->getDefaultBootOptionIndex();
	if ( defaultOption < 0 ) return defaultOption;

	// And that of the next option
	int nextOption = lilo->getNextBootOptionIndex();

	// Initialize the radioList array
	for ( int i = 0; i < MAX_OPTIONS; i++ )
		if ( radioList[i] )
		{
			delete radioList[i];
			radioList[i] = 0;
		}

	// Create the radio buttons
	for ( int i = 0; i < min ( int(options->count()), MAX_OPTIONS ); i++ )
	{
		// Create a new radio button and add it to the layout manager
		radioList[i] = new QRadioButton ( grp_select );
		radioList[i]->setText ( options->at(i) );
		radioList[i]->setMinimumSize ( radioList[i]->sizeHint() );
		lay_buttons->addWidget ( radioList[i] );

		if ( defaultOption == i )
		{
			// If the current option is the default option, it will be printed bold face,
			// and a tooltip indicates that it is the default button
			radioList[i]->font().setBold ( true );
			QToolTip::add ( radioList[i], i18n("This is the default boot option.") );
		}

		if ( i != int(options->count()) - 1 ) lay_buttons->addStretch ( 2 );
	}

	if ( nextOption >= 0 )
	{
		// If there is a next option, check the corresponding radio button and add
		// a tooltip
		radioList[nextOption]->setChecked ( true );
		QToolTip::add ( radioList[nextOption], i18n("The is the next boot option for the moment.") );
	}
	return 0;
}

int KBootSelWidget::writeNextOption ( LiloInfo *lilo )
{
	int indexSelected = -1;

	// Find the selected option
	for ( int i = 0; i < min ( int(options->count()), MAX_OPTIONS ); i++ )
	{
		if ( radioList[i]->isChecked() )
		{
			indexSelected = i;
			break;
		}
	}

	// If an option was selected, write that one as the next option; otherwise,
	// clear the next option.
	if ( indexSelected >= 0 )
		return lilo->setNextBootOption ( indexSelected );
	else
		return lilo->clearNextBootOption();
}

void KBootSelWidget::clearOptions()
{
	// Uncheck all radio buttons
	for ( int i = 0; i < min ( int(options->count()), MAX_OPTIONS ); i++ )
		radioList[i]->setChecked ( false );
}
