/*
  kcmpgp.cpp

  Copyright (c) 1997 Christian Stueble  stueble@ls6.cs.uni-dortmund.de
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
  */

#include <kcontrol.h>

#include "kcmpgp.h"
#include "pgpconfigtab.h"
#include "keyringtab.h"





KPGPApplication::KPGPApplication(int &argc, char **argv, const char *name) : 
  KControlApplication(argc, argv, name),
  config(0),
  keyring(0)
{
  if (runGUI())
    {      
      if (!pages || pages->contains("keyring"))
	addPage(keyring = new KeyringView(dialog, "keyring"), 
		"&KeyringView", "PGPKeyring.html");

      if (!pages || pages->contains("config"))
	addPage(config = new KPGPConfig(dialog, "config"), 
		"&PGPConfig", "PGPConfig.html");

      if (keyring && config)
	connect(config, SIGNAL(signalPubringChanged()), keyring, SLOT(slotPubringChanged()));

      if (keyring || config)
	{
	  dialog->show();
	}
      else
	{
	  fprintf(stderr, klocale->translate("usage: kcmpgp [-init | {keyring, config}]\n"));
          justInit = TRUE;
	}
    } 
}

void KPGPApplication::init()
{
  debug("KPGPApplication::init()");
}

void KPGPApplication::apply()
{
  debug("KPGPApplication::apply()");

  if (config)
    config->applySettings();

  if (keyring)
    keyring->applySettings();  
}

void KPGPApplication::defaultValues()
{
  debug("KPGPApplication::defaultValues()");

  if (config)
    config->defaultSettings();

  if (keyring)
    keyring->defaultSettings();  
}

int main(int argc, char **argv)
{
  KPGPApplication app(argc, argv, "kcmpgp");
  app.setTitle(klocale->translate("PGP Configuration"));
  
  if (app.runGUI())
    return app.exec();
  else
    {
      app.init();
      return 0;
    }
  
  return 0;
}
