/*
 * keyringtab.h
 *
 * Copyright (c) 1997 Christian Stueble  stueble@ls6.cs.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef KEYRINGTAB_H
#define KEYRINGTAB_H


#include <stdio.h>
#include <iostream.h>

#include <qstring.h>
#include <qlined.h>

#include <kcontrol.h>
#include <kconfig.h>

#include "ktrustselect.h"

#include "pgpkey.h"

#include "pgpkeyring.h"
#include "pgptreelist.h"


class KeyringView : public KConfigWidget
{
  Q_OBJECT;
  
public:
  
  KeyringView( QWidget *parent=0, const char* name=0 );
  ~KeyringView( );
  
  void  resizeEvent(QResizeEvent *e);

  /// Loads the settings, usually from an rc-file.
  void loadSettings();

  /// Applies the settings.
  void applySettings();

  /// Resets the default values
  void defaultSettings();
 
public slots:

  /// emittet if config file has changed
  void slotPubringChanged();

protected slots:

  void slotKeyMenuSelected(int);
  void slotUserIdMenuSelected(int);
  void slotSignatureMenuSelected(int);
  
  void slotLeftButtonSelected(QPoint, int);
  void slotRightButtonSelected(QPoint, int);
   
private:
  
  QList<PgpKey>   key_list;     // list of keyring keys
  PgpKeyring      *keyring;

  KTreeList       *list;       
  PgpKeyItem      *defaultKey;  // points to the default private key
  
  KPopupMenu      *infoMenu;
  KPopupMenu      *keyMenu;
  KPopupMenu      *userIdMenu;
  KPopupMenu      *signatureMenu;

  KTrustSelect    *keyTrustDialog;
};

class LineDialog : public QDialog
{
  Q_OBJECT

public:
  LineDialog(QWidget *parent = 0, const char *name = 0);
  ~LineDialog();

  QString getUserId();

private:

  QLineEdit *lineedit; 
};

#endif

