/* 
 * ktrustselect.cpp
 *
 * Copyright (c) 1997 Christian Stueble  stueble@ls6.cs.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ktrustselect.h"
#include "ktrustselect.moc"

#include <qlayout.h>
#include <qlabel.h>

#include <kbuttonbox.h>

KTrustSelect::KTrustSelect(const char *name) : 
  QDialog(0, name, TRUE),
  clicked_button(1)
{
  QRadioButton *pb;
 
  setCaption("Change Trust");
  resize(160, 200);
  
  g = new QButtonGroup("New Trust", this);
  g->move(5, 5);
  g->resize(150, 150);
  connect(g, SIGNAL(clicked(int)), this, SLOT(slotClicked(int)));
  
  pb = new QRadioButton("No Trust", g);
  pb->move(20, 20);
  g->insert(pb, 0);
  
  pb = new QRadioButton("Unknown Trust", g);
  pb->move(20, 45);
  g->insert(pb, 1);
  
  pb = new QRadioButton("Marginal Trust", g);
  pb->move(20, 70);
  g->insert(pb, 2);
  
  pb = new QRadioButton("Full Trust", g);
  pb->move(20, 95);
  g->insert(pb, 3);
  
  
  KButtonBox *bbox = new KButtonBox(this);
  QPushButton *b = bbox->addButton("Ok");
  b->setDefault(TRUE);
  connect(b, SIGNAL(clicked()), this, SLOT(accept()));
  bbox->addStretch(1);
  connect(bbox->addButton("Cancel"), SIGNAL(clicked()), this, SLOT(reject()));
  bbox->move(5, 155);
  bbox->layout();
};

KTrustSelect::~KTrustSelect()
{};

void KTrustSelect::setTrust(int button)
{
  ((QRadioButton*) g->find(clicked_button))->setChecked(FALSE);
  
  switch(button)
    {
       case 2:  clicked_button=0;
	        break;
       case 5:  clicked_button=2;
	        break;
       case 6:  clicked_button=3;
	        break;
       default: clicked_button=1;
    }
  
  ((QRadioButton*) g->find(clicked_button))->setChecked(TRUE);
};

int  KTrustSelect::getTrust()
{
  switch(clicked_button)
    {
       case 0:  return 2;
	        break;
       case 2:  return 5;
	        break;
       case 3:  return 6;
	        break;
       default: return 1;
    }
};
  
void KTrustSelect::slotClicked(int nr)
{
  clicked_button = nr;
};
  

