/*
 * pgpmpi.cpp
 *
 * Copyright (c) 1997 Christian Stueble  stueble@ls6.cs.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pgpmpi.h"
#include "pgp2key.h"

PgpMPI::PgpMPI()
    : bit_len(0), byte_len(0), num(0)
{};

PgpMPI::~PgpMPI()
{
  if (bit_len)
    delete [] num;
};

PgpMPI& PgpMPI::operator<<(QDataStream &ds)
{
  ds >> bit_len;
  
  byte_len = bit_len / 8;
  
  if (bit_len % 8)
    byte_len++;
  
  num = new UINT8[byte_len];
  
  ds.readRawBytes((char*) num, byte_len);
  
  return *this;
};

PgpMPI& PgpMPI::operator>>(QDataStream &ds)
{
  ds << bit_len;
  
  ds.writeRawBytes((char*) num, byte_len);
  
  return *this;
};
  
QString PgpMPI::keyId() const
{
  QString id;
	
  id.sprintf(KEYID_FORMAT, num[byte_len-4], num[byte_len-3], num[byte_len-2], num[byte_len-1]);
  
  return id;
};
    
UINT32  PgpMPI::store(UINT8 *dest)
{
  memcpy(dest, num, byte_len);
  
  return byte_len;
};

UINT32  PgpMPI::bitLen() const
{
  return bit_len;
};

UINT32  PgpMPI::byteLen() const
{
  return byte_len;
};
