/*
 * pgpsignature.h
 *
 * Copyright (c) 1997 Christian Stueble  stueble@ls6.cs.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef PGPSIGNATURE_H
#define PGPSIGNATURE_H

#include <qdstream.h>

class PgpKey;

class PgpSignature
{
public:
    
enum SigTrust {  Undefined  = 0,
		 Unknown    = 1,
		 NoSigTrust = 2,
		 Reasonably = 5,
		 Completely = 6,
		 Ultimately = 7 };

  PgpSignature();
  virtual ~PgpSignature();

  virtual void store(QDataStream &dest) = 0;

  // returns key-id of key who made this signature
  virtual QString keyId() = 0;

  // returns user-id of key who made this signature
  virtual QString userId() = 0;
  
  virtual int     getTrust() = 0;
  virtual void    setTrust(int new_trust) = 0;

protected:
  
  PgpKey *myKey;  // key, who made this signature, if available
};

#endif
