/***************************************************************************
 *
 *  Copyright (C) 1998 Neil Hart (nhart@magma.ca)
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Id: kprintadd.h,v 1.6 1998/04/24 14:46:46 nhart Exp nhart $
 *                                                                   
 ***************************************************************************/

#ifndef __KPRINTADD_H__
#define __KPRINTADD_H__

#include "kprintappl.h"

#include <qdialog.h>
#include <qpushbt.h>
#include <qradiobt.h>
#include <qbttngrp.h>
#include <qlined.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <qchkbox.h>
#include <qcombo.h>

// Create a dialog for adding a new local printer or editing an existing
//  entry. The distinction between the two is made by the constructor
//  argument isEditDialog.
class KLocalPrinterDialog : public QDialog 
{
	Q_OBJECT
public:
	KLocalPrinterDialog ( QWidget* parent, const char* name,
		const char* prName, const char* spool, const char* device,
		int prTypeIdx, const char* note, bool isEditDialog,
		KPrinterApplication* k );
	~KLocalPrinterDialog ();

	const char* printerName();
	const char* printerSpool();
	const char* printerDevice();
	const char* printerType();
	int         printerTypeIndex();
	const char* printerNote();

signals:

	void okToLeave();

private slots:

	void okButtonPressed();
	void printerNameChanged(const char*);

private:

	QLineEdit* nameEdit;
	QLineEdit* spoolEdit;
	QComboBox* deviceEdit;
	QListBox* printerModel;
	QLineEdit* noteEdit;
	KPrinterApplication* kpa;
	
};

// Create a dialog for adding a new remote printer or editing an existing
//  entry. The distinction between the two is made by the constructor
//  argument isEditDialog.
class KRemotePrinterDialog : public QDialog 
{
	Q_OBJECT
public:
	KRemotePrinterDialog ( QWidget* parent, const char* name,
		const char* prName, const char* spool, const char* host,
		const char* queue, const char* note, bool isEditDialog,
		KPrinterApplication* k);
	~KRemotePrinterDialog ();

	const char* printerName();
	const char* printerSpool();
	const char* printerHost();
	const char* printerQueue();
	const char* printerNote();

signals:

	void okToLeave();

private slots:

	void okButtonPressed();
	void printerNameChanged(const char*);

private:

	QLineEdit* nameEdit;
	QLineEdit* spoolEdit;
	QLineEdit* hostEdit;
	QLineEdit* queueEdit;
	QLineEdit* noteEdit;
	KPrinterApplication* kpa;
	
};

#endif
