//
// editorsectionname.h
//
// written by Michael Riedel <Michael.Riedel@gmx.de>
//
// KBuilder Editor Window Header
//

#ifndef	KBUILDER_Editor_H
#define	KBUILDER_Editor_H

#include <qstring.h>
#include <qdir.h>

#include <kmenubar.h>
#include <kprocess.h>
#include <ktopwidget.h>
#include <ktoolbar.h>
#include <drag.h>

#include "KColorMLE.h"



class Editor : public KTopLevelWidget
{
    Q_OBJECT
public:
    Editor(QWidget *parent = 0, const char *name = 0, const char* file = 0);
    virtual ~Editor();

    bool isDirty();
	bool gotoLine(int line);

		/**
			This  method searches for an Editor widget that contains the
			file with the given filename; all Editor widgets opened in the
			same application are added to the static list Editors and can
			be iterated.
			@return the return value is either null, if there is no Editor widget
			with the desired file open, or a pointer to the (first!) Editor containing
			the file.
		*/
	static Editor* findEditorWidget(QString& filename);


protected:
	KSyntaxMultiLineEdit *editbuffer;	 // editor widget
	KMenuBar* mainMenu;                  // main menu
	QPopupMenu* modeMenu;				 // menu for adding modes
	KStatusBar* label;                   // statusbar
	KToolBar* toolbar;					 // toolbar
    QString fileName;                    // name of file in editor
    static QList<Editor> Editors;     	 // list of all open editors
    int firstModeID, lastModeID;		 // ID of first/last menu item for Mode selection
    QDir modeFiles;						 // contains names of all mode files for menu selection
    int modeIndex;						 // takes index of actual mode
	KDNDDropZone* dropZone;				 // Drop zone object for dragging Files onto the Editor

	bool load(const QString& fname);
    bool save(bool force = false);
	bool doSavingIfNeeded();             
	void setTitle(const QString& name);
	void changeFileState(const QString& name);
	void deleteThis();
	void setupView();
	void setupMenuBar();
	void setupStatusBar();
	void setupKeystrokes();
	void setupToolBar();
	void setupModes();

		// event handler:
    void resizeEvent(QResizeEvent* ev);	
    void closeEvent(QCloseEvent* ev);


public slots:
	void newFileSlot();
    void openFileSlot();
    void saveFileSlot();
    void saveAsFileSlot();
    void saveFileAndCloseWindowSlot();
    void closeWindowSlot();
    void selectFontSlot();
	void replaceAgainSlot();
	void searchAgainSlot();
	void optionsColorsSlot();
	void optionsSettingsSlot();
	void optionsConfigureKeysSlot();
	void optionsSelectModeSlot(int id);
	void makeSlot();
	void helpIndexSlot();
	void helpAboutSlot();
	void helpAboutQtSlot();


protected slots:
    void updateDirtyFlagSlot();
    void insModeChangedSlot();
	void cursorPosChangedSlot();
	void editorSettingsApplied();
	void colorsAppliedSlot();
	void filesDroppedSlot(KDNDDropZone*);
	void test();	// shows undo list entries
};



inline bool Editor::isDirty() { return editbuffer->dirty(); }

#endif
