//
// findreplace.h
//
// written by Michael Riedel <Michael.Riedel@gmx.de>

#include <qdialog.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qgrpbox.h>
#include <qchkbox.h>
#include <qkeycode.h>
#include <qlabel.h>

#include <stdlib.h>
#include <ctype.h>



/////////////////////////////////////////////////////
//
//

class KEdGotoLine : public QDialog
{
	Q_OBJECT;

public:
	KEdGotoLine(QWidget *parent = 0, const char *name = 0, int numLines = 0xffffffff);

	int getLineNumber() { return atoi(lineNum->text()); }
	void markText()     { lineNum->selectAll(); }


private:
	QPushButton* ok, *cancel;
	QGroupBox*   frame;
	QLineEdit*   lineNum;

	void resizeEvent(QResizeEvent *);
	void focusInEvent(QFocusEvent *);
};



/////////////////////////////////////////////////////
//
//

class KEdSrch : public QDialog
{
    Q_OBJECT;

public:
    KEdSrch ( QWidget *parent = 0, const char *name=0);

    QString getText();
    void setText(const QString& string);
    bool case_sensitive();
    bool directionIsBackward();


public slots:
    void done_slot();
    void ok_slot();


protected:
    void focusInEvent( QFocusEvent *);
    void resizeEvent(QResizeEvent *);
    void insertSearchText(const QString& text);

private:
    QPushButton *ok, *cancel;
    QCheckBox *sensitive;
    QCheckBox *direction;
    QGroupBox *frame1;
	QComboBox *value;

signals:
    void search_signal();
    void search_done_signal();
};



/////////////////////////////////////////////////////
//
//

class KEdReplace : public QDialog
{
    Q_OBJECT;

public:

    KEdReplace ( QWidget *parent = 0, const char *name=0);

    QString 	getText();
    QString 	getReplaceText();
    void 	setText(QString);
    QLineEdit 	*value;
    QLineEdit 	*replace_value;
    QLabel 	*label;
    bool 	case_sensitive();
    bool 	directionIsBackward();

protected:

    void focusInEvent( QFocusEvent *);
    void resizeEvent ( QResizeEvent *);

private:

    QPushButton *ok, *cancel, *replace, *replace_all;
    QCheckBox 	*sensitive;
    QCheckBox 	*direction;
    QGroupBox 	*frame1;


signals:

    void replace_signal();
    void find_signal();
    void replace_all_signal();
    void replace_done_signal();

public slots:
     
    void done_slot();
    void replace_slot();
    void replace_all_slot();
    void ok_slot();

};
